/* annasta Woocommerce Product Filters Premium Javascript */

var a_w_f = typeof( a_w_f ) === 'undefined' ? {} : a_w_f;
a_w_f.premium = true;

jQuery( document ).ready( function( $ ) {
  'use strict';
  
  a_w_f.preset_wrappers = $( '.awf-preset-wrapper' );

  a_w_f.build_taxonomy_range_slider = function( range_container ) {
    
    var min = parseInt( $( range_container ).attr( 'data-min' ) );
    var max = parseInt( $( range_container ).attr( 'data-max' ) );
    
    var range_values = $( range_container ).attr( 'data-values' ).split( ',' );
    $( range_values ).each( function( i, v ) {
      range_values[i] = parseInt( v );
    });
    
    var labels = $( range_container ).attr( 'data-labels' ).split( '_+_' );
        
    noUiSlider.create( range_container, {
      range: {
        'min': [min],
        'max': [max]
      },
      start: [parseInt( $( range_container ).attr( 'data-min-handle' ) ), parseInt( $( range_container ).attr( 'data-max-handle' ) )],
      step: 1,
      pips: {
        mode: 'values',
        values: range_values,
        density: 5
      },
      connect: true,
      margin: 1,
      tooltips: false,
      behaviour: 'drag'
    });
    
    $.each( range_values, function( i, value ) {
      $( range_container ).find( '.noUi-value[data-value=' + value + ']' ).html( labels[i] );
    });
    
    range_container.noUiSlider.on( 'change', function ( new_min_max, handle ) {
      var $range_container = $( range_container );
      
      if( $range_container.hasClass( 'awf-button-filter' ) && ! ( 'pre_button_query' in awf_data ) ) {
        awf_data.pre_button_query = $.extend( true, {}, awf_data.query );
      }  

      if( $( range_container ).closest( '.awf-filter-wrapper' ).hasClass( 'awf-reset-all' ) ) {
        a_w_f.reset_all_filters( [ $range_container.find( '.awf-filter' ).first().attr( 'data-taxonomy' ) ] );
      }
      
      a_w_f.taxonomy_range_update_values( range_values, range_container, new_min_max );
      
      var $preset_wrapper = $range_container.closest( '.awf-preset-wrapper' );

      if( $preset_wrapper.hasClass( 'awf-sbs' ) ) {

        if( '1' === $range_container.attr( 'data-force-sbs-redirect' ) ) {
          $preset_wrapper.addClass( 'awf-sbs-redirect' );
        }
  
        a_w_f.update_sbs( $preset_wrapper, $range_container.closest( '.awf-filter-wrapper' ).first().attr( 'data-sbs-i' ), ( '1' === $range_container.attr( 'data-apply-sbs' ) ) );
      }  

      if( ! ( $range_container.hasClass( 'awf-range-btn' ) || $preset_wrapper.hasClass( 'awf-button' ) ) ) {
        a_w_f.apply_filter( true, $preset_wrapper );
      }
    });
  };

  a_w_f.preset_wrappers.find( '.awf-taxonomy-range-slider-container' ).each( function( i, sc ) {
    a_w_f.build_taxonomy_range_slider( sc );
  });

  a_w_f.adjust_dropdown_footer = function( $dropdown ) {

    if( ! $dropdown.hasClass( 'awf-collapsed' ) ) {
      var t = $dropdown.find( '.awf-filters-container' ).outerHeight( true ) + $dropdown.find( '.awf-filter-title-container' ).outerHeight();

      if( $dropdown.hasClass( 'awf-button-filter' ) ) {
        var $sbc = $dropdown.find( '.awf-submit-btn-container' ).first();
        if( 0 === $sbc.length ) { $sbc = $dropdown.find( '.awf-apply-filter-btn, button[name="awf_submit"]' ).first(); }

        if( 0 < $sbc.length ) {
          t -= $sbc.outerHeight( true );
          $sbc.css( 'top', t + 'px' );
        }
      }

      if( $dropdown.hasClass( 'awf-thl' ) ) {
        a_w_f.update_thl( $dropdown, true );

        var $thc = $dropdown.find( '.awf-thl-container:visible' ).first();
        if( 0 < $thc.length ) {
          t -= $thc.outerHeight( true );
          $thc.css( 'top', t + 'px' );
        }
      }
    }
  };

  $( document ).on( 'awf_after_setup', function() {

    $( document ).on( 'awf_ajax_filter', function() {
      if( ! ( 'disable_dropdown_autocollapse_1' in awf_data ) ) {
        $( '.awf-dropdown:not(.awf-collapsed) .awf-filter-title-container' ).each( function() {
          a_w_f.toggle_collapsible( $( this ) );
        });
      }
    });
  
    a_w_f.preset_wrappers.find( '.awf-dropdown' ).each( function () {

      var $dropdown = $( this );
  
      $dropdown.find( '.awf-active-badges-container' ).each( function( i, badges ) {
        $( badges ).siblings( '.awf-filters-container' ).prepend( '<div class="awf-active-badges-container"></div>' );
      } );
  
      $dropdown.find( '.awf-reset-active-container' ).each( function( i, reset_active ) {
        var $reset_active = $( reset_active );
        $reset_active.prependTo( $reset_active.siblings( '.awf-filters-container' ) );
      } );
  
      $dropdown.filter( '.awf-button-filter.awf-hl:not(.awf-adjust-dd-footer)' ).each( function() {
        $(this).one( 'click', function() { a_w_f.adjust_dropdown_footer( $( this ) ); } );
      });
  
      $dropdown
        .on( 'focusout', function( e ) {
          var $dropdown = $( this );
          if( 0 === $dropdown.has( $( e.relatedTarget ) ).length && ! $dropdown.hasClass( 'awf-collapsed' ) ) {

            if( ! ( 'disable_dropdown_autocollapse_2' in awf_data ) ) {
              a_w_f.toggle_collapsible( $dropdown.find( '.awf-filter-title-container' ).first() );
            }

            if( ( 'blockui_focus_backup' in a_w_f ) && ! a_w_f.blockui_focus_backup.hasClass( 'awf-togglable-preset-btn') ) {
              a_w_f.blockui_focus_backup = $dropdown;
            }
          }
        }
      );
  
      $dropdown.find( '.awf-filter-title-container' ).first()
        .on( 'click', function() {
          a_w_f.toggle_collapsible( $( this ) );
  
          if( $dropdown.hasClass( 'awf-adjust-dd-footer' ) ) {
            var $d = $( this ).closest( '.awf-filter-wrapper' );
  
            if( ! $d.hasClass( 'awf-collapsed' ) ) {
              a_w_f.adjust_dropdown_footer( $d );
            }
          }
        }
      );
  
      var $af_dropdowns = $dropdown.filter( '.awf-adjust-dd-footer' );
      
      $af_dropdowns.find( '.awf-filters-container, .awf-clear-terms-search-btn' )
        .on( 'click', function() {
          a_w_f.adjust_dropdown_footer( $( this ).closest( '.awf-filter-wrapper' ) );
        }
      );
  
      $af_dropdowns.find( '.awf-terms-search' )
        .on( 'input', function() {
          a_w_f.adjust_dropdown_footer( $( this ).closest( '.awf-filter-wrapper' ) );
        }
      );
    });  
  } );

  if( ! ( 'redirect_ajax' in awf_data ) ) {
    if( ( 'title_badges' in awf_data ) ) {
      $( document ).on( 'awf_after_setup', function() { a_w_f.add_title_badges(); });
      $( document ).on( 'awf_after_ajax_products_update', function() { a_w_f.add_title_badges(); });
    }

    $( document ).on( 'awf_after_setup', function() {

      var $erbc = $( '.awf-extra-reset-btn-container');

      if( 0 < $erbc.length ) {
        if( 0 < a_w_f.products_wrappers.find( awf_data.no_result_container ).length && 0 < $( $.map( awf_data.query, function( el,i ) { return i; } ) ).not( awf_data.reset_all_exceptions ).get().length ) {
          $erbc.show();
        }
      }
    });

    if( 'yes' === awf_data.wrapper_reload ) {
      if( ! ( 'title_badges' in awf_data ) ) {
        $( document ).on( 'awf_after_ajax_products_update', function() {
          a_w_f.products_wrappers.find( '.awf-extra-badges').replaceWith( $( '#awf-title-badges-storage' ).clone( true ).attr( 'id', '' ).attr( 'style', '' ).addClass( 'awf-active-badges-container awf-extra-badges' ) );
        });
      }

      $( document ).on( 'awf_after_setup', function() {
        if( 0 < a_w_f.products_wrappers.find( '.awf-extra-reset-btn-container').length ) {
          $( document ).on( 'awf_after_ajax_products_update', function() {
            if( 0 < $( '.awf-active-badge' ).first().length ) {
              a_w_f.products_wrappers.find( '.awf-extra-reset-btn-container').show();
            } else {
              a_w_f.products_wrappers.find( '.awf-extra-reset-btn-container').hide();
            }
          });
        }
      });    
    }
  }

  var $filter_wrappers = $( '.awf-filter-wrapper' );

  if( $filter_wrappers.hasClass( 'awf-af' ) ) {

    a_w_f.active_filters = $filter_wrappers.filter( '.awf-af' );

    a_w_f.active_filters.each( function( i, filter_wrapper ) {
      var $fw = $( filter_wrapper );

      if( 0 < $fw.find( '.awf-filters-container.ps--active-y' ).first().length ) {
        $fw.addClass( 'awf-af-ps' );
      }
    } );

    a_w_f.update_active_filters = function() {

      a_w_f.active_filters.each( function( i, filter_wrapper ) {

        var $fw = $( filter_wrapper );

        if( ( 'af_taxonomy' in a_w_f ) && 'undefined' !== typeof ( a_w_f.af_taxonomy ) && a_w_f.af_taxonomy !== $fw.attr( 'data-taxonomy' ) ) { return true; }

        var $fcs = $fw.find( '.awf-filter-container' );
        var $afcs = $fcs.filter( '.awf-active' );

        if( 0 < $afcs.length ) {
          $fcs.addClass( 'awf-hidden-af' );

          $afcs.removeClass( 'awf-hidden-af' ).next( 'ul' ).find( '.awf-filter-container' ).removeClass( 'awf-hidden-af' );

          $afcs.each( function( ii, afc ) {

            var $afss = $( afc ).siblings().not( '.awf-active' );

            if( $fw.hasClass( 'awf-hide-afss' ) ) {
              if( ! $afss.is( 'ul' ) ) {
                $afss.removeClass( 'awf-hidden-af' );
              }
            } else {
              $afss.filter( '.awf-filter-container' ).each( function( iii, afs ) {
                var $afs = $( afs );
                var $dscs = $afs.next( 'ul' ).find( '.awf-filter-container' );

                if( ! $dscs.hasClass( 'awf-active' ) ) {
                  $afs.removeClass( 'awf-hidden-af' );
                  $dscs.removeClass( 'awf-hidden-af' );
                }
              } );
            }
          } );

          if( $fw.hasClass( 'awf-luf' ) ) {
            $fw.find( '.awf-luf-btn' ).remove();
            $afcs.closest( 'ul.awf-children-container' ).prepend( '<div class="awf-luf-btn' + ( $fw.hasClass( 'awf-button-filter' ) ? ' awf-luf-force-submit' : '' ) + '" title="' + $fw.attr( 'data-luf-tip' ) + '"><i class="fas fa-level-up-alt"></i></div>' );

          } else if( $fw.hasClass( 'awf-hide-afp' ) ) {

          } else {
            $afcs.parentsUntil( '.awf-filters-container' ).removeClass( 'awf-hidden-af' );
          }

        } else {
          $fw.find( '.awf-luf-btn' ).remove();
          $fcs.removeClass( 'awf-hidden-af' );
        }
        
        if( $fw.hasClass( 'awf-af-ps' ) ) {
          var $fsc = $fw.find( '.awf-filters-container' ).first();
          $.each( a_w_f.pretty_scrollbars, function( i, ps ) {
            if( $fsc.has( $( ps.element ) ) ) { ps.update(); }
          });
        }

        if( 'af_margins_adjustment' in awf_data ) {
          $fw.find( 'ul' ).removeClass( 'awf-af-adjusted-margin' );
          $afcs.first().closest( 'ul' ).addClass( 'awf-af-adjusted-margin' ).parentsUntil( '.awf-filters-container > ul' ).addClass( 'awf-af-adjusted-margin' );
        }

      } );

      delete a_w_f.af_taxonomy;
    };

    $( document ).on( 'click', '.awf-af .awf-filter, .awf-af .awf-reset-active-container, .awf-active-badge', function() {
      a_w_f.af_taxonomy = $( this ).attr( 'data-taxonomy' );
    } );

    $( document ).on( 'click', '.awf-af .awf-apply-filter-btn', function() {
      a_w_f.af_taxonomy = $( this ).closest( '.awf-filter-wrapper' ).attr( 'data-taxonomy' );
    } );

    $( document ).on( 'awf_ajax_filter', function() {
      a_w_f.update_active_filters();
    } );

    if( a_w_f.active_filters.hasClass( 'awf-luf' ) ) {
      $( document ).on( 'click', '.awf-luf-btn', function() {
        var $btn = $( this );
        var $force_submit = false;

        if( $btn.hasClass( 'awf-luf-force-submit' ) ) {
          $force_submit = $btn.closest( '.awf-filter-wrapper' ).find( '.awf-apply-filter-btn' );
        }

        if( $btn.hasClass( 'awf-luf-reload' ) ) { a_w_f.page_reload = true; }
        $btn.closest( '.awf-children-container' ).prev( '.awf-filter-container.awf-parent-container' ).find( '.awf-filter' ).trigger( 'click' );

        if( $force_submit ) { $force_submit.trigger( 'click' ); }
      } );
    }

    a_w_f.update_active_filters();
  }

  if( $filter_wrappers.hasClass( 'awf-hide-empty-filter' ) ) {

    a_w_f.hide_empty_filters = $filter_wrappers.filter( '.awf-hide-empty-filter' );
      
    a_w_f.update_hidden_filter = function( $filter_wrapper ) {

      var $hidden = $filter_wrapper.find( '.awf-filter-container.awf-empty-hidden.awf-empty' );
      var threshold = $filter_wrapper.hasClass( 'awf-hft-one' ) ? 1 : 0;

      if( $hidden.hasClass( 'awf-unhide-active' ) ) {
        $hidden = $hidden.not( '.awf-active' );
      }

      if( $filter_wrapper.hasClass( 'awf-af' ) ) {
        $hidden = $hidden.add( $filter_wrapper.find( '.awf-filter-container.awf-hidden-af' ) );
      }

      if( ( $filter_wrapper.attr( 'data-terms-count' ) - $hidden.length ) <= threshold ) {
        $filter_wrapper.addClass( 'awf-empty-filter-hidden' );
      } else {
        $filter_wrapper.removeClass( 'awf-empty-filter-hidden' );
      }
    };

    a_w_f.hide_empty_filters.each( function( i, filter_wrapper ) {
      var $filter_wrapper = $( filter_wrapper );

      $filter_wrapper.attr( 'data-terms-count', $filter_wrapper.find( '.awf-filter-container' ).length );
      a_w_f.update_hidden_filter( $filter_wrapper );
      $filter_wrapper.addClass( 'awf-hide-empty-filter-on' );
    });

    $( document ).on( 'awf_after_counts_update', function() {
      a_w_f.hide_empty_filters.each( function( i, filter_wrapper ) {
        a_w_f.update_hidden_filter( $( filter_wrapper ) );
      });
    } );
  }

  if( $filter_wrappers.hasClass( 'awf-thl' ) ) {

    var $thl = $filter_wrappers.filter( '.awf-thl' );

    a_w_f.update_thl = function( $filter_wrappers, force_a_dd ) {

      if( 'undefined' === typeof( force_a_dd ) ) { force_a_dd = false; }
      
      $filter_wrappers.each( function() {
        var $fw = $( this );

        if( force_a_dd || ! $fw.hasClass( 'awf-adjust-dd-footer' ) ) {
          var $fsc = $fw.find( '.awf-filters-container' );
          var h = $fsc.css( 'height', 'auto').css( 'max-height', 'none').outerHeight( true );

          $fsc.css( 'height', '').css( 'max-height', '');

          if( h > $fw.attr( 'data-thl-height' ) ) {
            $fw.addClass( 'awf-thl-on' );
          } else {
            $fw.removeClass( 'awf-thl-on' );
          }
        }
      });
    };

    $( document ).on( 'awf_after_setup', function() {

      $thl.each( function() {
        var $fw = $( this );

        $fw.find( '.awf-thl-more-btn' ).on( 'click', function() {
          $fw.toggleClass( 'awf-thl-expanded' );

          if( $fw.hasClass( 'awf-dropdown' ) ) {
            a_w_f.adjust_dropdown_footer( $fw );
          }
          $fw.find( '.awf-thl-less-btn' ).focus();
        });

        $fw.find( '.awf-thl-less-btn' ).on( 'click', function() {
          $fw.toggleClass( 'awf-thl-expanded' );

          if( $fw.hasClass( 'awf-dropdown' ) ) {
            a_w_f.adjust_dropdown_footer( $fw );
          }
          $fw.find( '.awf-thl-more-btn' ).focus();
        });
      });

      a_w_f.update_thl( $thl );

      $( document ).on( 'awf_after_counts_update', function() { a_w_f.update_thl( $thl ); } );
      $( document ).on( 'input', '.awf-filter-wrapper.awf-thl .awf-terms-search', function() { a_w_f.update_thl( $( this ).closest( '.awf-filter-wrapper.awf-thl') ); });
      $( document ).on( 'click', '.awf-filter-wrapper.awf-thl .awf-clear-terms-search-btn', function() { a_w_f.update_thl( $( this ).closest( '.awf-filter-wrapper.awf-thl') ); });
    } );

  }
  
  a_w_f.set_active_dropdown_title = function( $filter_wrappers ) {

    $filter_wrappers.each( function( i, el ) {

      var $filter_wrapper = $( el );

      if( $filter_wrapper.hasClass( 'awf-active-dropdown-title' ) ) {
        var $label = $filter_wrapper.find( '.awf-active label, .awf-hierarchical-sbs-active-parent label' ).first();

        if( 0 < $label.length ) {
          $filter_wrapper.find( '.awf-filter-title' ).text( $label.attr( 'data-badge-label' ) );
        } else {
          $filter_wrapper.find( '.awf-filter-title' ).text( $filter_wrapper.attr( 'data-default-title' ) );
        }
      }

    } );
  }

  a_w_f.set_active_dropdown_title( $( '.awf-active-dropdown-title' ) );
  
  a_w_f.set_premium_filter_events = function( $filter_container, $filter ) {
    var $filter_wrapper = $filter.closest( '.awf-filter-wrapper' );
    
    if( $filter_wrapper.hasClass( 'awf-reset-all' ) ) {
      if( $filter_container.hasClass( 'awf-product-search-container' ) ) {
        $filter.on( 'change', function() { a_w_f.reset_all_filters( [$( this ).attr( 'data-taxonomy' )] ); });
        
      } else if( $filter_container.hasClass( 'awf-daterangepicker-container' ) ) {
        var $daterangepicker = $filter_container.find( '.awf-daterangepicker' ).first();
        $daterangepicker.on( 'apply.daterangepicker', function() {
          a_w_f.reset_all_filters( [$filter.attr( 'data-taxonomy' )] );
        });
        $daterangepicker.on( 'cancel.daterangepicker', function() {
          a_w_f.reset_all_filters( [$filter.attr( 'data-taxonomy' )] );
        });
        
      } else if( ! $filter_container.hasClass( 'awf-range-slider-container' ) ) {
        $filter.on( 'click', function() {
          a_w_f.reset_all_filters( [$( this ).attr( 'data-taxonomy' )] );
        });
      }
    }

    if( $filter_wrapper.hasClass( 'awf-redirect-to-archives' ) ) {
      $filter.on( 'click', function() {
        var $filter = $( this );
        var $fw = $filter.closest( '.awf-filter-wrapper' );

        if( $fw.is( '[data-archive-redirect]' ) ) {
          awf_data.filters_url = $fw.attr( 'data-archive-redirect' );

        } else if( $filter.is( '[data-archive-permalink]' ) ) {
          awf_data.filters_url = $filter.attr( 'data-archive-permalink' );

        } else {
          return;
        }
        
        awf_data.archive_page = $filter.attr( 'data-taxonomy' );
        awf_data.archive_identifier = $fw.attr( 'data-archive-indentifier' );
        awf_data.archive_page_trailingslash = $fw.attr( 'data-archive-trailingslash' );
        awf_data.archive_page_switch = '/awf-archive-redirect' + awf_data.archive_page_trailingslash;
      } );
    }
  };
  
  a_w_f.range_slider_reset_all = function( $range_container ) {
    var taxonomies = [];
    $range_container.find( '.awf-filter' ).each( function( i, el ) {
      taxonomies.push( $( el ).attr( 'data-taxonomy' ) );
    });
    
    a_w_f.reset_all_filters( taxonomies );
  };
  
  a_w_f.update_reset_all_hrefs = function( $wrapper ) {
    $wrapper.find( '.awf-filter' ).each( function( ii, filter ) {

      var query = {};
      var $filter = $( filter );
      var filter_values = [];
      
      if( ( $filter.attr( 'data-taxonomy' ) in awf_data.query ) && ! $filter.is( ':radio' ) ) {
        filter_values = awf_data.query[$filter.attr( 'data-taxonomy' )].split( ',' );
        
        if( -1 !== $.inArray( $filter.val(), filter_values ) ) {
          filter_values.splice( $.inArray( $filter.val(), filter_values ), 1 );
        }
      }
      
      $.each( awf_data.reset_all_exceptions, function( i, v ) {
        if( ( v in awf_data.query ) && v !== $filter.attr( 'data-taxonomy' ) ) { query[v] = awf_data.query[v]; }
      } );
      
      if( ! $filter.is(':checked') && ! $filter.hasClass( 'awf-default' ) ) {
        
        if( $wrapper.hasClass( 'awf-multi' ) ) {
          $filter.parents( 'ul' ).prev( 'li.awf-filter-container' ).find( '.awf-filter' ).each( function( i, f ) {
            filter_values = $.grep( filter_values, function( v ) { return v !== $( f ).val(); } );
          });

          $filter.parents( 'li.awf-filter-container' ).next( 'ul' ).find( '.awf-filter' ).each( function( i, f ) {
            filter_values = $.grep( filter_values, function( v ) { return v !== $( f ).val(); } );
          });
        }

        filter_values.push( $filter.val() );
        if( $filter.is( '[data-max-name]' ) ) { query[$filter.attr( 'data-max-name' )] = $filter.attr( 'data-next-value' ); }
      }
      
      if( ! $.isEmptyObject( filter_values ) ) {
        filter_values.sort();
        query[$filter.attr( 'data-taxonomy' )] = filter_values.join( ',' );
      }

      if( $filter.is( '[data-archive-permalink]' ) ) {
        $filter.closest( 'a' ).attr( 'href', a_w_f.build_url( query, $filter.attr( 'data-archive-permalink' ) ) );
      } else {
        $filter.closest( 'a' ).attr( 'href', a_w_f.build_url( query ) );
      }

    });
  };
  
  a_w_f.get_interactive_tooltip_format = function( $slider ) {

    var format = {
      decimals: $slider.attr( 'data-decimals' ),
      mark: $slider.attr( 'data-decimals-separator' ),
      thousand: '',
    };

    if( 'enable_interactive_tooltips_thousand_separator' in awf_data ) {
      format.thousand = $slider.attr( 'data-thousand-separator' );
    }

    return format;
  };
  
  a_w_f.set_interactive_slider_tooltips = function( slider, format ) {
    var $slider = $( slider );
      
    if( 'below' === $slider.attr( 'data-tooltips' ) ) {
      a_w_f.set_tooltips_below( slider, $slider );
      return;
    }

    if( 'interactive_above' === $slider.attr( 'data-tooltips' ) ) {

      var $interactive_tooltips = $slider.siblings( '.awf-interactive-slider-tooltips-container' );

      $interactive_tooltips.find( 'input' ).each( function( i, input ) {

        $( input ).keydown( function( event ) {
            if( event.keyCode === 13 ) {
              if( $( this ).hasClass( 'awf-interactive-tooltip-0' ) ) {
                $interactive_tooltips.find( '.awf-interactive-tooltip-1' ).focus().select();

              } else {
                if( 0 < $interactive_tooltips.siblings( '.awf-apply-filter-btn' ).length ) {
                  $interactive_tooltips.siblings( '.awf-apply-filter-btn' ).focus().trigger( 'click' );
                } else {
                  $( this ).trigger( 'blur' );
                }
              }
              return false;
            }
        });

        input.addEventListener( 'change', function() { set_tooltip_value( slider, this ); });
        input.addEventListener( 'mousedown', stop_propagation );
        input.addEventListener( 'touchstart', stop_propagation );
        input.addEventListener( 'pointerdown', stop_propagation );
        input.addEventListener( 'MSPointerDown', stop_propagation );
      });

      slider.noUiSlider.on( 'update', function( values, handle ) {
        var tooltip_format = wNumb( a_w_f.get_interactive_tooltip_format( $slider ) );

        $interactive_tooltips.find( '.awf-interactive-tooltip-0' ).val( tooltip_format.to( parseFloat( values[0] ) ) );
        $interactive_tooltips.find( '.awf-interactive-tooltip-1' ).val( tooltip_format.to( parseFloat( values[1] ) ) );
      });

    }
    
    function stop_propagation( event ){ event.stopPropagation(); }

    function set_tooltip_value( slider, input ){
      var values = [null, null];

      var tooltip_format = wNumb( a_w_f.get_interactive_tooltip_format( $slider ) );
      
      values[$( input ).attr( 'data-handle' )] = tooltip_format.from( input.value );
      slider.noUiSlider.set( values );
      values = slider.noUiSlider.get();
      
      a_w_f.range_slider_onchange( slider, values, slider.noUiSlider.options.range.min[0], slider.noUiSlider.options.range.max[0] );
    }
  };
    
  a_w_f.set_tooltips_below = function( slider, $slider ) {

    var $tb = $( '<div class="awf-slider-tooltips-below"></div>' );
    $tb.appendTo( $slider );

    slider.noUiSlider.on( 'update', function ( values, handles, unencoded, tap, positions, noUiSlider ) {
      var tvs = [];

      $.each( values, function( i, v ) {
        if( noUiSlider.options.direction === 'rtl' && i === 1 ) {
          tvs.unshift( format.to( parseFloat( v ) ) );
        } else {
          tvs.push( noUiSlider.options.pips.format.to( parseFloat( v ) ) );
        }
      });

      $tb.html( tvs.join( ' - ' ) );
    });
  };

  a_w_f.reset_taxonomy_range = function( $container ) {
    $container.closest( '.awf-taxonomy-range-slider-container' ).each( function( i, range ) {
      var min = range.noUiSlider.options.range.min;
      var max = range.noUiSlider.options.range.max;
      range.noUiSlider.set( [min, max] );
      a_w_f.taxonomy_range_update_values( range.noUiSlider.options.pips.values, range, [min, max] );
    });
  };
  
  a_w_f.create_taxonomy_range_badge = function( $container ) {
    var $range_container = $container.closest( '.awf-taxonomy-range-slider-container' );
    var values = $range_container[0].noUiSlider.get();
    var labels = $range_container.attr( 'data-labels' ).split( '_+_' );
    
    return $range_container.attr( 'data-label' ) + ' ' + labels[( parseInt( values[0] ) - 1 )] + ' - ' + labels[( parseInt( values[1] ) - 1 )];
  };

  a_w_f.taxonomy_range_update_values = function( range_values, range_container, new_min_max ) {
    
    $( new_min_max ).each( function( i, v ) {
      new_min_max[i] = parseInt( v );
    });
    var new_values = range_values;
    new_values = new_values.slice( ( new_min_max[0] - 1 ), new_min_max[1] );

    var $a_filter = $( range_container ).find( '[data-taxonomy-range-value="' + new_values[0] + '"]' );
    var taxonomy = $( $a_filter ).attr( 'data-taxonomy' );
    var $filter_wrappers = $( '.awf-filter-wrapper[data-taxonomy="' + taxonomy + '"]' );

    $filter_wrappers.find( '.awf-filter-container.awf-active' ).removeClass( 'awf-active' ).find( 'input' ).prop( 'checked', false );
    
    delete awf_data.query[taxonomy];

    $filter_wrappers.find( '.awf-taxonomy-range-slider-container' ).each( function( i, range ) {
      if( range !== range_container ) {
        range.noUiSlider.set( [new_min_max[0], new_min_max[1]] );
      }
    });
    
    if( range_values[0] === new_min_max[0] && ( range_values[range_values.length - 1] ) === new_min_max[1] ) {
      a_w_f.update_query( $a_filter, $a_filter.closest( '.awf-filter-container' ), true );
      
    } else {
      $( new_values ).each( function( i, v ) {
        var input = $( range_container ).find( '[data-taxonomy-range-value="' + v + '"]' );
        $( 'input.awf-filter[data-taxonomy="' + taxonomy + '"][value="' + input.val() + '"]' ).prop( 'checked', true ).closest( '.awf-filter-container' ).addClass( 'awf-active' );
        a_w_f.update_query( input, input.closest( '.awf-filter-container' ), false );
      });

      a_w_f.adjust_reset_active( taxonomy, $a_filter );
    }
  }
  
  a_w_f.add_title_badges = function() {
		
    if( 0 === $( '#awf-title-badges' ).length ) {

			var $badges = $( '#awf-title-badges-storage' ).clone( true ).attr( 'id', 'awf-title-badges' ).attr( 'style', '' );
			var $reference_container;
			
			if( 'title_badges_insert_before' in awf_data ) { // example for title_badges_insert_before: '.products, .woocommerce-info'
				$reference_container = $( awf_data.title_badges_insert_before ).first();
				
			} else {

				$reference_container = $( '.page-title' ).first();

				if( 0 === $reference_container.length ) {
					$reference_container = a_w_f.products_wrappers.first().find( '.awf-preset-wrapper' ).last();
					if( 0 < $reference_container.length ) {
						$badges.insertAfter( $reference_container );
						return;
					}
					
				} else {
					$badges.insertAfter( $reference_container );
					return;
				}
				
				$reference_container = a_w_f.products_wrappers.first().find( awf_data.products_container ).first();
				if( 0 === $reference_container.length ) { $reference_container = a_w_f.products_wrappers.first().find( awf_data.no_result_container ).first(); }
			}
			
			$badges.insertBefore( $reference_container );

    } else {
      if( 'no' === awf_data.wrapper_reload ) {
        $( '#awf-title-badges' ).replaceWith( $( '#awf-title-badges-storage' ).clone( true ).attr( 'id', 'awf-title-badges' ).attr( 'style', '' ) );
      }
    }
  };
  
  a_w_f.adjust_dropdown_options = function() {
		$( '.awf-dropdown' ).each( function( i, dropdown ) {
      var $dropdown = $( dropdown );

      var $badges = $dropdown.find( '.awf-active-badges-container' );
      if( 0 < $badges.length ) {
        $badges.contents().prependTo( $badges.siblings( '.awf-filters-container' ).find( '.awf-active-badges-container' ) );
      }
		} );
  };

  a_w_f.adjust_cc_filters = function( $fsc ) {
    $fsc.find( '.awf-parent-container' ).removeClass( 'awf-hide-collapse-button' ).not( '.awf-empty:not(.awf-active.awf-unhide-active)' ).each( function() {
      var $p = $( this );
      var $children = $p.next( 'ul' ).find( '.awf-filter-container' );
      if( $children.length === $children.filter( '.awf-empty' ).not( '.awf-unhide-active.awf-active' ).length ) {
        $p.addClass( 'awf-hide-collapse-button' ).find( 'label' ).first().attr( 'aria-describedby', '' );
      } else {
        $p.find( 'label' ).first().attr( 'aria-describedby', 'awf-cc-access-msg' );
      }
    });
  };
  
  a_w_f.adjust_reset_active = function( taxonomy, $filter ) {

    if( $filter.hasClass( 'awf-range-slider-max' ) ) {
      taxonomy = $filter.siblings( '.awf-range-slider-min' ).attr( 'data-taxonomy' );
    }

    if( taxonomy in awf_data.query ) {
      $( '.awf-reset-active-container[data-taxonomy="' + taxonomy + '"]' ).show();
    } else {
      $( '.awf-reset-active-container[data-taxonomy="' + taxonomy + '"]' ).hide();
    }
  };

  a_w_f.filter_reset_taxonomies = [];

  $( '.awf-reset-active-container' ).each( function() {
    var $reset_container = $( this );
    var taxonomy = $reset_container.attr( 'data-taxonomy' );

    if( a_w_f.filter_reset_taxonomies.indexOf( taxonomy ) < 0 ) {
      a_w_f.filter_reset_taxonomies.push( taxonomy );

      var taxonomy_max = $reset_container.attr( 'data-taxonomy-max' );
      if( 'undefined' !== typeof( taxonomy_max) && false !== taxonomy_max ) {
        a_w_f.filter_reset_taxonomies.push( $reset_container.attr( 'data-taxonomy-max' ) );
      }
    }

		$reset_container.on( 'click', function() {
      a_w_f.reset_filter( taxonomy );
      a_w_f.apply_filters_reset( $reset_container.closest( '.awf-preset-wrapper' ) );
    });
  } );

  a_w_f.hierarchical_sbs_onclick = function( $filter, $container, taxonomy ) {

    if( $filter && ! $filter.hasClass( 'awf-hierarchical-sbs-filter' ) ) {
      $filter = $( '.awf-filter.awf-hierarchical-sbs-taxonomy.awf-hierarchical-sbs-filter[data-taxonomy="' + taxonomy + '"][value="' + $filter.val() + '"]' );

      if( 0 === $filter.length ) { return; }

      $container = $filter.closest( '.awf-filter-container' );
    }

    if( false !== $filter && $filter.prop( 'checked' ) && $container.hasClass( 'awf-hierarchical-sbs-active-parent' ) ) {
      $( '.awf-filter-container.awf-active .awf-filter[data-taxonomy="' + taxonomy + '"][value="' + $filter.val() + '"]' ).each( function( i, f ) {
        var $f = $( f );
        var $c = $f.closest( '.awf-filter-container' );

        $f.prop( 'checked', false );
        $c.removeClass( 'awf-active' );
        if( 0 === i ) { a_w_f.update_query( $f, $c, false ); }

        var parent = $c.closest( '.awf-children-container' ).attr( 'data-parent' );
        $( '.awf-filter[data-taxonomy="' + taxonomy + '"][value="' + parent + '"]' ).each( function( i, pf ) {
          var $pf = $( pf );
          var $pc = $pf.closest( '.awf-filter-container' );
  
          $pf.prop( 'checked', true );
          $pc.addClass( 'awf-active' );
          if( 0 === i ) { a_w_f.update_query( $pf, $pc, false ); }
        } );
      } );

      var $children = $( '.awf-children-container[data-parent="' + $filter.val() + '"]' );

      while( 0 < $children.length ) {
        var selectors = [];

        $children.find( '.awf-filter-container.awf-active, .awf-filter-container.awf-hierarchical-sbs-active-parent' ).each( function( i, container ) {
          var $c = $( container );
          var $f = $c.find( '.awf-filter' );
          if( $c.hasClass( 'awf-active' ) ) {
            $c.removeClass( 'awf-active' );
            $f.prop( 'checked', false );
            a_w_f.update_query( $f, $c, false );
          }

          if( -1 === selectors.indexOf( $f.val() ) ) { selectors.push( $f.val() ); }
        });

        $.each( selectors, function( i, v ) {
          selectors[i] = '.awf-children-container[data-parent="' + v + '"]';
        } );

        $children = $( selectors.join( ',' ) );
      }
    }

    if( false !== $filter ) { a_w_f.update_query( $filter, $container, false ); }

    var active_values = ( taxonomy in awf_data.query ) ? awf_data.query[taxonomy].split( ',' ) : [];

    $.each( active_values, function( i, v ) {
      var parent = $( '.awf-hierarchical-sbs .awf-filter[data-taxonomy="' + taxonomy + '"][value="' + v + '"]' ).closest( '.awf-children-container' ).attr( 'data-parent' );
      var $parents = $( '.awf-filter[data-taxonomy="' + taxonomy + '"][value="' + parent + '"]' ).closest( '.awf-filter-container' );

      while( 0 < $parents.length ) {
        if( $parents.hasClass( 'awf-active' ) ) {
          $parents.each( function( i, container ) {
            var $c = $( container );
            var $f = $c.find( '.awf-filter' );
            $c.removeClass( 'awf-active' );
            $f.prop( 'checked', false );
            if( 0 === i ) { a_w_f.update_query( $f, $c, false ); }
          } );
        }

        parent = $( '.awf-hierarchical-sbs .awf-filter[data-taxonomy="' + taxonomy + '"][value="' + parent + '"]' ).closest( '.awf-children-container' ).attr( 'data-parent' );
        $parents = $( '.awf-filter[data-taxonomy="' + taxonomy + '"][value="' + parent + '"]' ).closest( '.awf-filter-container' );
      }
    } );

    $( '.awf-hierarchical-sbs[data-taxonomy="' + taxonomy + '"]' ).each( function( i, hierarchical_sbs ) {
      var $hierarchical_sbs = $( hierarchical_sbs );
      $hierarchical_sbs.addClass( 'awf-hierarchical-sbs-disabled' );
      $hierarchical_sbs.find( '.awf-children-container' ).removeClass( 'awf-hierarchical-sbs-enabled' );
      $hierarchical_sbs.find( '.awf-hierarchical-sbs-active-parent' ).removeClass( 'awf-hierarchical-sbs-active-parent' );
    } );

    if( taxonomy in awf_data.query ) {
      active_values = awf_data.query[taxonomy].split( ',' );

      $.each( active_values, function( i, v ) {
        var $filter_containers = $( '.awf-hierarchical-sbs .awf-filter[data-taxonomy="' + taxonomy + '"][value="' + v + '"]' ).closest( '.awf-filter-container' );

        var parent = $filter_containers.closest( '.awf-children-container' ).addClass( 'awf-hierarchical-sbs-enabled' ).attr( 'data-parent' );
        $filter_containers.closest( '.awf-hierarchical-sbs' ).removeClass( 'awf-hierarchical-sbs-disabled' );

        var $immediate_children = $( '.awf-hierarchical-sbs[data-taxonomy="' + taxonomy + '"] .awf-children-container[data-parent="' + v + '"]' ).addClass( 'awf-hierarchical-sbs-enabled' );
        $immediate_children.closest( '.awf-hierarchical-sbs' ).removeClass( 'awf-hierarchical-sbs-disabled' );

        var $parents = $( '.awf-hierarchical-sbs .awf-filter[data-taxonomy="' + taxonomy + '"][value="' + parent + '"]' ).closest( '.awf-filter-container' );

        while( 0 < $parents.length ) {
          $parents.addClass( 'awf-hierarchical-sbs-active-parent' );

          var $hierarchical_sbs = $parents.closest( '.awf-hierarchical-sbs' );
          $hierarchical_sbs.removeClass( 'awf-hierarchical-sbs-disabled' );
          var $hierarchical_sbs_children = $hierarchical_sbs.find( '.awf-filter[data-taxonomy="' + taxonomy + '"][value="' + parent + '"]' ).closest( '.awf-children-container' );
          $hierarchical_sbs_children.addClass( 'awf-hierarchical-sbs-enabled' );

          parent = $hierarchical_sbs_children.first().attr( 'data-parent' );
          $parents = $( '.awf-hierarchical-sbs .awf-filter[data-taxonomy="' + taxonomy + '"][value="' + parent + '"]' ).closest( '.awf-filter-container' );
        }
      } );
    }

  };

  $( '.awf-hierarchical-sbs' ).each( function() {
    var $hierarchical_sbs = $( this );
    var taxonomy = $hierarchical_sbs.attr( 'data-taxonomy' );

    if( ! ( 'hierarchical_sbs_taxonomies' in a_w_f ) ) { a_w_f.hierarchical_sbs_taxonomies = []; }

    if( -1 === a_w_f.hierarchical_sbs_taxonomies.indexOf( taxonomy ) ) { a_w_f.hierarchical_sbs_taxonomies.push( taxonomy ); }

    if( 0 === $hierarchical_sbs.find( '.awf-children-container' ).length ) {
      $( this ).addClass( 'awf-hierarchical-sbs-root' )
    }
  } );

  if( 'undefined' !== typeof( awf_data ) && 'hierarchical_sbs_taxonomies' in a_w_f  ) {
    $.each( a_w_f.hierarchical_sbs_taxonomies, function( i, taxonomy ) {
      $( '.awf-filter-wrapper[data-taxonomy="' + taxonomy + '"]' ).each( function() {
        var $filter_wrapper = $( this );

        $filter_wrapper.find( '.awf-filter' ).each( function() {
          var $filter = $( this );

          if( $filter_wrapper.hasClass( 'awf-hierarchical-sbs' ) ) {
            $filter.addClass( 'awf-hierarchical-sbs-taxonomy' ).addClass( 'awf-hierarchical-sbs-filter' );
          } else {
            $filter.addClass( 'awf-hierarchical-sbs-taxonomy' );
          }
        } );
      } );

      if( taxonomy in awf_data.query ) { a_w_f.hierarchical_sbs_onclick( false, false, taxonomy ); }
    } );

    delete a_w_f.hierarchical_sbs_taxonomies;
  }
  
});