<?php

defined( 'ABSPATH' ) or die( 'Access denied' );

if( ! class_exists( 'A_W_F_premium_filter_frontend' ) ) {
  
  class A_W_F_premium_filter_frontend extends A_W_F_filter_frontend {

    public function __construct( $preset_frontend, $filter_id ) {
      parent::__construct( $preset_frontend, $filter_id );
    }

    protected function edit_filter_wrapper( &$classes, &$options, &$append ) {
      
      if( ! empty( $this->settings['reset_all'] ) ) { $classes[] = 'awf-reset-all';  }

      if( ! empty( $this->settings['is_dropdown'] ) ) {
        $classes[] = 'awf-dropdown';
        $classes[] = 'awf-collapsed';

        if( ! empty( $this->settings['active_dropdown_title'] ) ) {
          $classes[] = 'awf-active-dropdown-title';
          $options .= ' data-default-title="' . esc_attr( $this->settings['title'] ) . '"';
        }

        if( ! empty( $this->settings['style_options']['disable_dropdown_autocollapse'] ) && ( 'ajax-delegated' === A_W_F::$front->preset->type || 'ajax-button' === A_W_F::$front->preset->type ) ) {
          $classes[] = 'awf-disable-autocollapse';
        }
        
      } elseif( ! empty( $this->settings['is_collapsible'] ) ) {
        $classes[] = 'awf-collapsible';
        if( ! empty( $this->settings['collapsed_on'] ) ) { $classes[] = 'awf-collapsed'; }
      }
      
      if( 'taxonomy' === $this->module ) {
        if( in_array( $this->settings['taxonomy'], get_option( 'awf_badges_exceptions', array() ) ) ) {
          $this->input_classes[] = 'awf-no-active-badge';
        }

        if( ! empty( $this->settings['hide_filter'] ) ) {
          $classes[] = 'awf-hide-empty-filter';
          $classes[] = 'awf-hft-' . $this->settings['hide_filter'];
        }

        if( ! empty( $this->settings['terms_limitation_mode'] ) && 'active' === $this->settings['terms_limitation_mode'] ) {
          if( ! empty( $this->settings['style_options']['active_filter_level_up'] ) ) {
            $classes[] = 'awf-luf';
            $options .= ' data-luf-tip="' . ( empty( $this->settings['style_options']['active_filter_level_up_tip'] ) ? '' : esc_attr( $this->settings['style_options']['active_filter_level_up_tip'] ) ) . '"';

          } elseif( ! empty( $this->settings['style_options']['hide_active_filter_parents'] ) ) {
            $classes[] = 'awf-hide-afp';
          }
        }

        if( ! empty( $this->settings['redirect_to_archive'] ) && A_W_F::$front->permalinks_on && in_array( $this->settings['type'], array( 'single', 'multi' ) ) && A_W_F::$front->is_archive !== $this->settings['taxonomy'] ) {
          $classes[] = 'awf-redirect-to-archives';
          $options .= ' data-archive-indentifier="' . esc_attr( A_W_F::$front->vars->misc['archive'] ) . '" data-archive-trailingslash="' . user_trailingslashit( '' ) . '"';

          if( 'yes' === get_option( 'awf_hierarchical_archive_permalinks', 'no' ) ) {
            $this->settings['type'] = 'single';
            $this->input_classes[] = 'awf-redirect-to-archive';

          } else {
            global $wp_rewrite;

            $link = $wp_rewrite->get_extra_permastruct( $this->settings['taxonomy'] );
            if( $link ) {
              $link = str_replace( "%" . $this->settings['taxonomy'] . "%", 'awf-archive-redirect', $link );

              if( class_exists( 'SitePress' ) && ! empty( A_W_F::$front->get_nondefault_language() ) ) {
                $link = A_W_F::$front->adjust_wpml_custom_taxonomy_base( '/' . rtrim( ltrim( $link, '/' ), '/' ) . '/', '', $this->settings['taxonomy'] );
              }

              $link = user_trailingslashit( home_url( $link ), 'category' );
              $options .= ' data-archive-redirect="' . esc_attr( $link ) . '"';
            }
          }
        }

      } else {
        if( in_array( $this->module, get_option( 'awf_badges_exceptions', array() ) ) ) {
          $this->input_classes[] = 'awf-no-active-badge';
        }
      }

      if( in_array( $this->settings['type'], array( 'single', 'multi') ) ) {
        if( ! empty( $this->settings['hierarchical_sbs'] ) ) {
          $classes['hierarchical_sbs'] = 'awf-hierarchical-sbs';
          $classes[] = 'awf-hierarchical-sbs-disabled';
        }
      }

      if( ! empty( $this->settings['height_limit'] ) && ( 'form' !== A_W_F::$front->preset->type ) ) {
        $classes[] = 'awf-hl';

        if( ! empty( $this->settings['style_options']['height_limit_style'] ) && 'toggle' === $this->settings['style_options']['height_limit_style'] ) {
          $classes[] = 'awf-thl';
          if( ! empty( $this->settings['is_dropdown'] ) ) { $classes[] = 'awf-adjust-dd-footer'; }
          $options .= ' data-thl-height="' . intval( $this->settings['height_limit'] ) . '"';
          
          $append = '<div class="awf-thl-container"><div class="awf-thl-more-btn" role="button" aria-label="' . esc_attr__( 'Show more', 'annasta-filters' ) . '" tabindex="0">' . esc_html__( 'Show more', 'annasta-filters' ) . '</div><div class="awf-thl-less-btn" role="button" aria-label="' . esc_attr__( 'Show less', 'annasta-filters' ) . '" tabindex="0">' . esc_html__( 'Show less', 'annasta-filters' ) . '</div></div>' . $append;
        }
      }
    }

    protected function filter_title_html( $is_collapsible, $collapsed_on ) {
      if( ! empty( $this->settings['is_dropdown'] ) ) {
        $is_collapsible = true;
        $collapsed_on = true;
      }

      return parent::filter_title_html( $is_collapsible, $collapsed_on );
    }

    protected function collapse_btn_html() {
      if( ! empty( $this->settings['is_collapsible'] ) || ! empty( $this->settings['is_dropdown'] ) ) {
        return '<div class="awf-collapse-btn"></div>';
      } else {
        return '';
      }
    }
    
    protected function interactive_tooltips_html() {
      $html = '<div class="awf-interactive-slider-tooltips-container" >';
      $html .= '<div class="awf-interactive-tooltip-container"><input id="' . $this->cid . '-it0" class="awf-interactive-tooltip-0" type="text" data-handle="0" /></div>';
      $html .= '<div class="awf-interactive-tooltip-container"><input id="' . $this->cid . '-it1" class="awf-interactive-tooltip-1" type="text" data-handle="1" /></div>';
      $html .= '</div>';
      
      return $html;
    }

    protected function set_term_label( &$term ) {
      if( isset( $this->settings['style_options']['term_labels'][$term->term_id] ) ) {
        $term->name = $this->settings['style_options']['term_labels'][$term->term_id];
        if( 'range-stars' === $this->settings['style']
           && empty( $this->settings['style_options']['term_labels'][$term->term_id] ) )
        {
          $term->name = '&nbsp;';
        }
      }
    }

    protected function set_hide_empty( $slug, &$container_classes, &$input_props ) {
      if( 'none' !== $this->settings['hide_empty'] ) {

        switch( $this->settings['hide_empty'] ) {
          case 'hidden':
            $container_classes[] = 'awf-empty-hidden';
            if( ! empty( $this->settings['unhide_active_filter'] ) ) {
              $container_classes[] = 'awf-unhide-active';
            }  
            break;
          case 'css': $container_classes[] = 'awf-empty-css'; break;
          case 'disabled': $container_classes[] = 'awf-empty-disabled'; break;
          default: break;
        }

        if( 0 === A_W_F::$front->counts[$this->settings['taxonomy']][$slug] ) {

          $container_classes[] = 'awf-empty';

          if( 'disabled' === $this->settings['hide_empty'] ) {
            $input_props[] = 'disabled';
          }
        }
      }
    }

    protected function add_range_slider_container_classes() {
      if( ! empty( $this->settings['reset_all'] ) ) { return ' awf-reset-all'; }
      else { return ''; }
    }

    protected function setup_numeric_taxonomy_range() {
      $this->set_range_active_values();
    }

    public function get_reset_all_url( $term ) {

      $url = A_W_F::$front->current_url;
      
      if( is_null( A_W_F::$front->reset_all_url_exceptions ) ) { A_W_F::$front->build_reset_all_url_exceptions(); }
      $url_filters = A_W_F::$front->reset_all_url_exceptions;
			
			if( isset( $url_filters[A_W_F::$front->vars->awf['search']] ) ) {
				$url_filters[A_W_F::$front->vars->awf['search']] = urlencode( $url_filters[A_W_F::$front->vars->awf['search']] );
			}
      
      if( ! isset( $url_filters[$this->var_name] ) ) { $url_filters[$this->var_name] = $this->active_values; }

      if( 'range' === $this->settings['type'] ) {
        if( in_array( $term->slug, $this->active_values ) && in_array( $term->next_value, $this->active_values ) ) {
          unset( $url_filters[$this->var_name] );
          unset( $url_filters[$this->max_var_name] );
        } else {
          $url_filters[$this->var_name] = $term->slug;
          $url_filters[$this->max_var_name] = $term->next_value;
        }
        
      } else {

        $i = array_search( $term->slug, $url_filters[$this->var_name] );
        
        if( false === $i ) {
          if( 'single' === $this->settings['type'] ) {
            if( $term->slug === $this->default_value ) { unset( $url_filters[$this->var_name] );
            } else { $url_filters[$this->var_name] = array( $term->slug ); }
          } else {
            if( 0 !== $term->parent ) {
              $this->remove_ancestors( $term, $url_filters[$this->var_name] );
            }

            if( isset( A_W_F::$front->page_associations[$this->settings['taxonomy']][$term->term_id] ) || isset( A_W_F::$front->page_parent_associations[$this->settings['taxonomy']][$term->term_id] ) ) {
              $children = get_terms( array(
                'taxonomy' => $this->settings['taxonomy'],
                'fields' => 'slugs',
                'child_of' => (int) $term->term_id,
                'hide_empty' => false
              ));

              $url_filters[$this->var_name] = array_diff( $url_filters[$this->var_name], $children );
            }

            $url_filters[$this->var_name][] = $term->slug;
          }
          
        } else {
          unset( $url_filters[$this->var_name][$i] );
        }
      }

      array_filter( $url_filters[$this->var_name] );
      sort( $url_filters[$this->var_name] );

      if( A_W_F::$front->is_archive ) {
        
        $url_filters[A_W_F::$front->vars->misc['archive']] = 1;

        if( 'taxonomy' === $this->module && A_W_F::$front->is_archive === $this->settings['taxonomy'] ) {


          if( empty( $url_filters[$this->var_name] ) ) {
            $url_filters[$this->var_name][] = $term->slug;
          }

          if( A_W_F::$front->permalinks_on ) {
            if( 'yes' === get_option( 'awf_hierarchical_archive_permalinks', 'no' ) && 'single' === $this->settings['type'] ) {
              $url = get_term_link( $term->slug, A_W_F::$front->is_archive );
              if( is_wp_error( $url ) ) { $url = A_W_F::$front->current_url; }
              
            } else {
              $replace = user_trailingslashit( '/' . implode( ',', A_W_F::$front->query->tax[A_W_F::$front->is_archive] ) );
              $pos = strrpos( A_W_F::$front->current_url, $replace );
              if( $pos !== false ) {
                $url = substr_replace( A_W_F::$front->current_url, user_trailingslashit( '/' . implode( ',', $url_filters[$this->var_name] ) ), $pos, strlen( $replace ) );
              }
            }

          } else {
            $url_filters[A_W_F::$front->is_archive] = implode( ',', $url_filters[$this->var_name] );
          }
          
          unset( $url_filters[$this->var_name] );
        }
      }
      
      if( isset( $url_filters[$this->var_name] ) && is_array( $url_filters[$this->var_name] ) ) {
        if( empty( $url_filters[$this->var_name] ) ) {
          unset( $url_filters[$this->var_name] );
        } else {
          $url_filters[$this->var_name] = implode( ',', $url_filters[$this->var_name] );
					if( empty( $url_filters[$this->var_name] ) ) { unset( $url_filters[$this->var_name] ); }
        }
      }
      
      return add_query_arg( $url_filters, $url );
    }
    
    protected function taxonomy_range_slider_html() {
      $values_count = count( $this->settings['type_options']['range_values'] );
      
      if( $values_count < 2 ) { return ''; }
      
      $max_value = end( $this->settings['type_options']['range_values'] );
      $min_value = reset( $this->settings['type_options']['range_values'] );
      $is_active_range = false;
      
      if( empty( $this->active_values ) ) {
        $this->active_values = array_keys( $this->settings['type_options']['range_values'] );
        $min_handle = $min_value;
        $max_handle = $max_value;
        
      } else {
        $active_range = array_flip( $this->active_values );
        $active_range = array_intersect_key( $this->settings['type_options']['range_values'], $active_range );
        asort( $active_range );
        $last_value = end( $active_range );
        $first_value = reset( $active_range );
        
        if( 1 < count( $active_range ) ) {
          $is_active_range = true;
          foreach( $active_range as $slug => $position ) {
            if( ( $position !== $last_value ) && ! in_array( ( $position + 1 ), $active_range ) ) {
              $is_active_range = false; break;
            }
          }
        }
        
        if( $is_active_range ) {
          $min_handle = $first_value;
          $max_handle = $last_value;
        } else {
          $min_handle = $min_value;
          $max_handle = $max_value;
        }
        
      }
      
      $html = '<div class="awf-taxonomy-range-slider-container';
      if( ! empty( $this->settings['button_submission'] ) ) { $html .= ' awf-range-btn'; }
      $html .= '"';
      $html .= ' data-min="' . esc_attr( $min_value ) . '" data-max="' . esc_attr( $max_value ) . '"';
      $html .= ' data-label="';
      if(! empty( $this->settings['active_prefix'] ) ) { $html .= esc_attr( $this->settings['active_prefix'] ); }
      $html .= '"';
      $html .= ' data-values="' . esc_attr( implode( ',', $this->settings['type_options']['range_values'] ) ) . '"';
      $html .= ' data-labels="' . esc_attr( implode( '_+_', $this->settings['type_options']['range_labels'] ) ) . '"';
      $html .= ' data-min-handle="' . esc_attr( $min_handle ) . '"';
      $html .= ' data-max-handle="' . esc_attr( $max_handle ) . '"';
      $html .= '>';

      foreach( $this->settings['type_options']['range_values'] as $slug => $range_value ) {

        $checked = '';

        $html .= '<div class="awf-filter-container awf-' . $this->var_name . '-' . $slug . '-container';
        if( in_array( $slug, $this->active_values ) ) {
          if( $is_active_range ) { $html .= ' awf-active'; }
          $checked = ' checked="checked"';
        }
        $html .= ' awf-taxonomy-range-container">';

        $html .= '<input type="checkbox" id="' . $this->cid . '-' . $this->var_name . '-' . esc_attr( $slug ) . '"';
        $html .= ' name="' . esc_attr( $this->var_name ) . '[]"';
        $html .= ' value="' . esc_attr( $slug ) . '" data-taxonomy="' . esc_attr( $this->var_name ) . '"';
        $html .= ' class="' . implode( ' ', $this->input_classes ) . ' awf-taxonomy-range-value"';
        $html .= ' data-taxonomy-range-value="' . esc_attr( $range_value ) . '"' . $checked . '>';
        
        $html .= '<label for="' . $this->cid . '-' . $this->var_name . '-' . esc_attr( $slug ) . '" title="' . esc_attr( $this->settings['type_options']['range_labels'][$slug] ) . '">';
        $html .= esc_html( $this->settings['type_options']['range_labels'][$slug] ) . '</label>';

        $html .= '</div>';
      }

      $html .= '</div>';
      
      if( ! empty( $this->settings['button_submission'] ) ) {
        if( 'form' === A_W_F::$front->preset->type ) {
          $html .= '<button type="submit" name="awf_submit" value="1">' . esc_html( $this->settings['style_options']['submit_button_label'] ) . '</button>';

        } else {
          $html .= '<button type="button" class="awf-apply-filter-btn">' . esc_html( $this->settings['style_options']['submit_button_label'] ) . '</button>';
        }
      }

      return $html;
    }    
  }
}

?>