<?php if ( ! defined( 'ABSPATH' ) ) { exit; } ?>
              <tr>
                <td>
                  <label for="<?php echo $filter->prefix; ?>collapse_options"><?php esc_html_e( 'Dropdown / collapsible', 'annasta-filters' ); ?></label>
                  <span class="woocommerce-help-tip" data-tip="<?php esc_attr_e( 'Display filter as a dropdown (select box), or make it collapsible by adding collapse buttons to the right of the filter title, allowing users to open and close the filter box.', 'annasta-filters' ); ?>"></span>
                </td>
                <td>
<?php
  $select_options = array(
    'name' => $filter->prefix . 'collapse_options',
    'id' => $filter->prefix . 'collapse_options',
    'class' => 'awf-filter-collapse-options-select',
    'selected' => ! empty( $filter->settings['is_dropdown'] ) ? 'is_dropdown' : ( ! empty( $filter->settings['is_collapsible'] ) ? 'is_collapsible' : 'none'),
    'options' => array(
      'none' => __( 'None', 'annasta-filters' ),
      'is_dropdown' => __( 'Display as dropdown', 'annasta-filters' ),
      'is_collapsible' => __( 'Display as collapsible filter', 'annasta-filters' ),
    )
  );

  echo A_W_F::$admin->build_select_html( $select_options );
?>
                  <div class="awf-collapsed-on-container" style="<?php if( ! empty( $filter->settings['is_dropdown'] ) || empty( $filter->settings['is_collapsible'] ) ) { echo 'display: none;'; } ?>">
                    <input type="checkbox" name="<?php echo $filter->prefix; ?>collapsed_on" id="<?php echo $filter->prefix; ?>collapsed_on" value="yes"<?php if( ! empty( $filter->settings['collapsed_on'] ) ) { echo ' checked="checked"'; } ?>>
                    <label for="<?php echo $filter->prefix; ?>collapsed_on"><?php esc_html_e( 'Initialize in a collapsed state', 'annasta-filters' ); ?></label>
                  </div>
                  <div class="awf-active-dropdown-title-container" style="<?php if( empty( $filter->settings['is_dropdown'] ) || 'single' !== $filter->settings['type'] ) { echo 'display: none;'; } ?>">
                    <input type="checkbox" name="<?php echo $filter->prefix; ?>active_dropdown_title" id="<?php echo $filter->prefix; ?>active_dropdown_title" value="yes"<?php if( ! empty( $filter->settings['active_dropdown_title'] ) ) { echo ' checked="checked"'; } ?>>
                    <label for="<?php echo $filter->prefix; ?>active_dropdown_title"><?php esc_html_e( 'Display active value as dropdown title', 'annasta-filters' ); ?></label>
                  </div>
                  <div class="awf-disable-dropdown-autocollapse-container" style="<?php if( empty( $filter->settings['is_dropdown'] ) ) { echo 'display: none;'; } ?>">
                    <input type="checkbox" name="<?php echo $filter->prefix; ?>disable_dropdown_autocollapse" id="<?php echo $filter->prefix; ?>disable_dropdown_autocollapse" value="yes"<?php if( ! empty( $filter->settings['style_options']['disable_dropdown_autocollapse'] ) ) { echo ' checked="checked"'; } ?>>
                    <label for="<?php echo $filter->prefix; ?>disable_dropdown_autocollapse"><?php esc_html_e( 'Disable dropdown auto-collapse', 'annasta-filters' ); ?><span class="woocommerce-help-tip" data-tip="<?php esc_attr_e( 'Disabling dropdown collapse after filter selection will only work in presets with filtering style set to AJAX with button or delegated submission. To prevent dropdown from auto-collapsing in other modes, enable the filter-level button submission.', 'annasta-filters' ); ?>"></span></label>
                  </div>
                </td>
              </tr>