var a_w_f = typeof( a_w_f ) === 'undefined' ? {} : a_w_f;
a_w_f.premium = true;

jQuery( document ).ready( function( $ ) {
  'use strict';

  a_w_f.toggle_active_badges_hook = function ( $hook ) {
    if( 'js' === $hook.val() ) {
      $hook.closest( '.awf-template-option-active-badges' ).addClass( 'hide-priority' );
    } else {
      $hook.closest( '.awf-template-option-active-badges' ).removeClass( 'hide-priority' );
    }
  };

  a_w_f.set_premium_filter_events = function ( $container ) {};
  
  a_w_f.set_premium_style_events = function ( type, style, $container ) {
    
    if( 'range' === type ) { awf_set_taxonomy_range_sortables( $container ); }
  };
    
  a_w_f.get_interactive_tooltip_format = function( $slider ) {

    var format = {
      decimals: $slider.attr( 'data-decimals' ),
      mark: $slider.attr( 'data-decimals-separator' ),
      thousand: '',
    };

    return format;
  };
  
  a_w_f.set_interactive_slider_tooltips = function( slider, $slider ) {
      
    function stop_propagation( event ){ event.stopPropagation(); }

    function set_tooltip_value( input ){
      var tooltip_format = wNumb( a_w_f.get_interactive_tooltip_format( $( slider ) ) );

      var values = [null, null];
      values[$( input ).attr( 'data-handle' )] = tooltip_format.from( input.value );
      slider.noUiSlider.set( values );
    }
    
    var $interactive_tooltips = $( slider ).siblings( '.awf-interactive-slider-tooltips-container' );
    if( $slider.hasClass( 'awf-rsp-hide-slider' ) ) { $interactive_tooltips.addClass( 'awf-slider-hidden' ); }

    $interactive_tooltips.find( 'input' ).each( function( i, input ) {
      $( input ).keydown( function( event ) {
        if( event.keyCode === 13 ) {
          if( $( this ).hasClass( 'awf-interactive-tooltip-0' ) ) {
            $interactive_tooltips.find( '.awf-interactive-tooltip-1' ).focus().select();

          } else {
            $( this ).trigger( 'blur' );
          }
          return false;
        }
      } );

      input.addEventListener( 'change', function() {
        set_tooltip_value( this );
      });
      input.addEventListener( 'mousedown', stop_propagation );
      input.addEventListener( 'touchstart', stop_propagation );
      input.addEventListener( 'pointerdown', stop_propagation );
      input.addEventListener( 'MSPointerDown', stop_propagation );
    });

    slider.noUiSlider.on( 'update', function( values, handle ) {
      var tooltip_format = wNumb( a_w_f.get_interactive_tooltip_format( $( slider ) ) );

      $interactive_tooltips.find( '.awf-interactive-tooltip-0' ).val( tooltip_format.to( parseFloat( values[0] ) ) );
      $interactive_tooltips.find( '.awf-interactive-tooltip-1' ).val( tooltip_format.to( parseFloat( values[1] ) ) );
    });
  };

  a_w_f.set_tooltips_below = function( slider, $slider ) {

    var $tb = $( '<div class="awf-slider-tooltips-below"></div>' );
    $tb.appendTo( $slider );

    slider.noUiSlider.on( 'update', function ( values, handles, unencoded, tap, positions, noUiSlider ) {
      var tvs = [];

      $.each( values, function( i, v ) {
        if( noUiSlider.options.direction === 'rtl' && i === 1 ) {
          tvs.unshift( format.to( parseFloat( v ) ) );
        } else {
          tvs.push( noUiSlider.options.pips.format.to( parseFloat( v ) ) );
        }
      });

      $tb.html( tvs.join( ' - ' ) );
    });
  };

  a_w_f.popup_preset_templates = function( $btn ) {

    $('.awf-spinner-overlay').show();

    $.ajax({
      type:     "post",
      url:      "admin-ajax.php",
      dataType: "html",
      data:     {
        action: 'awf_admin',
        awf_action: 'popup-preset-templates',
        awf_preset_id: $btn.attr( 'data-preset-id' ),
        awf_ajax_referer: awf_js_data.awf_ajax_referer
      },
      success:  function( response ) {
        $( '.awf-spinner-overlay' ).html( response );
      },
      error: function( response ) {
        a_w_f.ajax_error_response( response );
      }
    });
  };

  a_w_f.apply_preset_template = function() {
    if( confirm( awf_js_data.l10n.apply_preset_template_confirmation ) ) {

      var $popup = $( '.awf-overlay-popup.awf-preset-templates' ).first();
      $popup.block({ message: '' });      

      $.ajax({
        type:     "post",
        url:      "admin-ajax.php",
        data:     {
          action: 'awf_admin',
          awf_action: 'apply-preset-template',
          awf_preset_id: $popup.attr( 'data-preset-id' ),
          awf_preset_template_id: $( '#awf-apply-preset-template-select' ).val(),
          awf_ajax_referer: awf_js_data.awf_ajax_referer
        },
        success:  function() {
          if( false !== a_w_f.url_params ) {
            if( a_w_f.url_params.has( 'awf-expanded-filters' ) ) {
              a_w_f.url_params.delete( 'awf-expanded-filters' );
            }
            a_w_f.url_params.set( 'awf-force-submit', 1 );
            a_w_f.set_new_url();
          }

          window.onbeforeunload = null;
          window.location.reload();
        },
        error: function( response ) {
          a_w_f.ajax_error_response( response );
        }
      });
    }
  };

  a_w_f.apply_preset_clone = function() {
    if( confirm( awf_js_data.l10n.apply_preset_template_confirmation ) ) {

      var $popup = $( '.awf-overlay-popup.awf-preset-templates' ).first();
      $popup.block({ message: '' });

      $.ajax({
        type:     "post",
        url:      "admin-ajax.php",
        data:     {
          action: 'awf_admin',
          awf_action: 'apply-preset-clone',
          awf_preset_id: $popup.attr( 'data-preset-id' ),
          awf_clone_preset_id: $( '#awf-apply-preset-clone-select' ).val(),
          awf_ajax_referer: awf_js_data.awf_ajax_referer
        },
        success:  function() {
          if( false !== a_w_f.url_params ) {
            if( a_w_f.url_params.has( 'awf-expanded-filters' ) ) {
              a_w_f.url_params.delete( 'awf-expanded-filters' );
            }
            a_w_f.url_params.set( 'awf-force-submit', 1 );
            a_w_f.set_new_url();
          }

          window.onbeforeunload = null;
          window.location.reload();
        },
        error: function( response ) {
          a_w_f.ajax_error_response( response );
        }
      });
    }
  };

  a_w_f.popup_create_preset_template = function() {
    var $overlay = $('.awf-spinner-overlay');
    $overlay.show();

    $.ajax({
      type:     "post",
      url:      "admin-ajax.php",
      dataType: "html",
      data:     {
        action: 'awf_admin',
        awf_action: 'popup-create-preset-template',
        awf_ajax_referer: awf_js_data.awf_ajax_referer
      },
      success:  function( response ) {
        $overlay.html( response );
      },
      error: function( response ) {
        a_w_f.ajax_error_response( response );
      }
    });
  };

  a_w_f.create_preset_template = function( $btn ) {
    $('.awf-overlay-popup').block({ message: '' });

    $.ajax({
      type:     "post",
      url:      "admin-ajax.php",
      dataType: "html",
      data:     {
        action: 'awf_admin',
        awf_action: 'create-preset-template',
        awf_preset_id: $( '#awf-create-preset-template-presets-select' ).val(),
        awf_new_preset_template_name: $( '.awf-new-preset-template-name' ).first().val(),
        awf_ajax_referer: awf_js_data.awf_ajax_referer
      },
      success:  function() {
        window.onbeforeunload = null;
        window.location.reload();
      },
      error: function( response ) {
        a_w_f.ajax_error_response( response );
      }
    });
  };

  a_w_f.popup_rename_preset_template = function( $btn ) {
    var $overlay = $('.awf-spinner-overlay');
    $overlay.show();

    $.ajax({
      type:     "post",
      url:      "admin-ajax.php",
      dataType: "html",
      data:     {
        action: 'awf_admin',
        awf_action: 'popup-rename-preset-template',
        awf_preset_template_id: $btn.closest( '.awf-template-row' ).attr( 'data-preset-template-id' ),
        awf_ajax_referer: awf_js_data.awf_ajax_referer
      },
      success:  function( response ) {
        $overlay.html( response );
      },
      error: function( response ) {
        a_w_f.ajax_error_response( response );
      }
    });
  };

  a_w_f.rename_preset_template = function( $btn ) {
    $('.awf-spinner-overlay').show();

    $.ajax({
      type:     "post",
      url:      "admin-ajax.php",
      dataType: "html",
      data:     {
        action: 'awf_admin',
        awf_action: 'rename-preset-template',
        awf_preset_template_id: $btn.attr( 'data-preset-template-id' ),
        awf_preset_template_name: $( '.awf-rename-preset-template' ).first().val(),
        awf_ajax_referer: awf_js_data.awf_ajax_referer
      },
      success:  function() {
        window.onbeforeunload = null;
        window.location.reload();
      },
      error: function( response ) {
        a_w_f.ajax_error_response( response );
      }
    });
  };

  a_w_f.export_preset_template = function( $btn ) {
    var $overlay = $('.awf-spinner-overlay');
    $overlay.show();

    $.ajax({
      type:     "post",
      url:      "admin-ajax.php",
      dataType: "html",
      data:     {
        action: 'awf_admin',
        awf_action: 'export-preset-template',
        awf_preset_template_id: $btn.closest( '.awf-template-row' ).attr( 'data-preset-template-id' ),
        awf_ajax_referer: awf_js_data.awf_ajax_referer
      },
      success:  function( response ) {
        var $response = a_w_f.ajax_html_response_to_jquery( response, 'export-preset-template' );
        var $notice = $response.insertAfter( $( '#awf-settings > h2' ).first() );
				var $link = $notice.find( '.awf-preset-template-download-link' );
				if( 0 < $link.length ) { $link[0].click(); }
        $overlay.hide();
      },
      error: function( response ) {
        a_w_f.ajax_error_response( response );
      }
    });
  };

  a_w_f.import_template = function( event, template_type ) {
    if( typeof window.FileReader !== 'function' ) {
      alert( 'File import is not supported by your browser.' );
      return;
    }

    var files = event.target.files;
    var reader;

    if ( ! files || 0  === files.length ) {
      alert( 'Please select a valid file' );

    } else {
      reader = new FileReader();
      reader.onload = function( file ) {
    
        try {
          var json_object = JSON.parse( file.target.result );

          $.ajax({
            type:     "post",
            url:      "admin-ajax.php",
            dataType: "json",
            data:     {
              action: 'awf_admin',
              awf_action: 'import-template',
              awf_json_template: json_object,
              awf_json_template_type: template_type,
              awf_ajax_referer: awf_js_data.awf_ajax_referer
            },
            success:  function( response ) {
              if( typeof response === 'object' && response.hasOwnProperty( 'notices' ) ) {
                if( ! alert( response.notices ) ) {
                  if( response.hasOwnProperty( 'filter_name' ) ) {
                    if( false !== a_w_f.url_params ) {
                      a_w_f.url_params.set( 'awf-filter', response.filter_name );
                      a_w_f.set_new_url();
                    }
                  }
                  window.onbeforeunload = null;
                  window.location.reload();
                }
              }
            },
            error: function( response ) {
              a_w_f.ajax_error_response( response );
            }
          });

  
        } catch ( error ) {
          alert( 'Invalid template format!' );
        }
      };

      reader.readAsText( files[0] );
    }
  };

  a_w_f.delete_preset_template = function( $btn ) {
    $('.awf-spinner-overlay').show();

    $.ajax({
      type:     "post",
      url:      "admin-ajax.php",
      dataType: "html",
      data:     {
        action: 'awf_admin',
        awf_action: 'delete-preset-template',
        awf_preset_template_id: $btn.attr( 'data-preset-template-id' ),
        awf_ajax_referer: awf_js_data.awf_ajax_referer
      },
      success:  function( response ) {
        window.onbeforeunload = null;
        window.location.reload();
      },
      error: function( response ) {
        a_w_f.ajax_error_response( response );
      }
    });
  };

  a_w_f.popup_custom_layout = function() {

    $('.awf-spinner-overlay').show();

    $.ajax({
      type:     "post",
      url:      "admin-ajax.php",
      dataType: "html",
      data:     {
        action: 'awf_admin',
        awf_action: 'popup-custom-layout',
        awf_preset_id: $( '#awf-preset-id' ).val(),
        awf_ajax_referer: awf_js_data.awf_ajax_referer
      },
      success:  function( response ) {
        $( '.awf-spinner-overlay' ).html( response );
      },
      error: function( response ) {
        a_w_f.ajax_error_response( response );
      }
    });
  };

  a_w_f.add_custom_layout_column = function() {
    $.ajax({
      type:     "post",
      url:      "admin-ajax.php",
      dataType: "html",
      data:     {
        action: 'awf_admin',
        awf_action: 'add-custom-layout-column',
        awf_preset_id: $( '#awf-preset-id' ).val(),
        awf_ajax_referer: awf_js_data.awf_ajax_referer
      },
      success:  function( response ) {
        $( '.awf-spinner-overlay' ).html( response );
      },
      error: function( response ) {
        a_w_f.ajax_error_response( response );
      }
    });
  };

  a_w_f.delete_custom_layout_column = function( column ) {
    $.ajax({
      type:     "post",
      url:      "admin-ajax.php",
      dataType: "html",
      data:     {
        action: 'awf_admin',
        awf_action: 'delete-custom-layout-column',
        awf_preset_id: $( '#awf-preset-id' ).val(),
        awf_delete_column: column,
        awf_ajax_referer: awf_js_data.awf_ajax_referer
      },
      success:  function( response ) {
        $( '.awf-spinner-overlay' ).html( response );
      },
      error: function( response ) {
        a_w_f.ajax_error_response( response );
      }
    });
  };

  a_w_f.update_custom_layout = function( action, column ) {
    if( 'undefined' === typeof( action ) ) {
      action = 'save';
    }

    var $popup_container = $( '.awf-custom-layout-popup' );

    $popup_container.block({ message: '' });

    var column_options = {};
    $popup_container.find( '.awf-custom-layout-columns .awf-custom-layout-column-container').each( function() {
      var $column = $( this );
      var co = {};

      $column.find( 'input, select').each( function() {
        var $input = $( this );
        if( 'undefined' !== typeof( $input.attr( 'id' ) ) ) {
          if( $input.is( ':checkbox' ) ) {
            co[$input.attr( 'id' )] = $input.prop( 'checked' ) ? 1 : 0;
          } else {
            co[$input.attr( 'id' )] = $input.val();
          }
        }
      });

      column_options[$column.attr( 'data-column-n' )] = co;
    });

    var options = {};
    options['gap'] = $( '#awf-custom-layout-gap' ).val();
    options['gap-units'] = $( '#awf-custom-layout-gap-units' ).val();
    options['wrap'] = $( '#awf-custom-layout-wrap' ).prop( 'checked' ) ? 1 : 0;

    $.ajax({
      type:     "post",
      url:      "admin-ajax.php",
      dataType: "html",
      data:     {
        action: 'awf_admin',
        awf_action: 'update-custom-layout',
        awf_preset_id: $( '#awf-preset-id' ).val(),
        awf_custom_layout_columns: column_options,
        awf_custom_layout_options: options,
        awf_ajax_referer: awf_js_data.awf_ajax_referer
      },
      success:  function( response ) {
        if( 'add' === action ) {
          a_w_f.add_custom_layout_column();

        } else if( 'delete' === action ) {
          a_w_f.delete_custom_layout_column( column );

        } else {
          $( '.awf-spinner-overlay' ).hide().html( '' );
        }
        
      },
      error: function( response ) {
        a_w_f.ajax_error_response( response );
      }
    });
  };

  a_w_f.popup_filter_templates = function( $btn ) {

    $('.awf-spinner-overlay').show();

    $.ajax({
      type:     "post",
      url:      "admin-ajax.php",
      dataType: "html",
      data:     {
        action: 'awf_admin',
        awf_action: 'popup-filter-templates',
        awf_preset: $( '#awf-preset-id' ).val(),
        awf_filter: $btn.attr( 'data-filter-id' ),
        awf_ajax_referer: awf_js_data.awf_ajax_referer
      },
      success:  function( response ) {
        $( '.awf-spinner-overlay' ).html( response );
      },
      error: function( response ) {
        a_w_f.ajax_error_response( response );
      }
    });
  };

  a_w_f.apply_filter_template = function() {
    if( confirm( awf_js_data.l10n.apply_filter_template_confirmation ) ) {

      var $popup = $( '.awf-overlay-popup.awf-filter-templates' ).first();
      $popup.block({ message: '' });      

      $.ajax({
        type:     "post",
        url:      "admin-ajax.php",
        data:     {
          action: 'awf_admin',
          awf_action: 'apply-filter-template',
          awf_preset: $( '#awf-preset-id' ).val(),
          awf_filter: $popup.attr( 'data-filter-id' ),
          awf_filter_template_id: $( '#awf-apply-filter-template-select' ).val(),
          awf_ajax_referer: awf_js_data.awf_ajax_referer
        },
        success:  function( response ) {
          if( false !== a_w_f.url_params ) {
            a_w_f.url_params.set( 'awf-goto', 'awf-filter-' + $( '#awf-preset-id' ).val() + '-' + $popup.attr( 'data-filter-id' ) );
            a_w_f.url_params.set( 'awf-force-submit', 1 );
            a_w_f.set_new_url();
          }
          window.onbeforeunload = null;
          window.location.reload();
        },
        error: function( response ) {
          a_w_f.ajax_error_response( response );
        }
      });
    }
  };

  a_w_f.apply_filter_clone = function() {
    if( confirm( awf_js_data.l10n.apply_filter_template_confirmation ) ) {

      var $popup = $( '.awf-overlay-popup.awf-filter-templates' ).first();
      $popup.block({ message: '' });

      $.ajax({
        type:     "post",
        url:      "admin-ajax.php",
        data:     {
          action: 'awf_admin',
          awf_action: 'apply-filter-clone',
          awf_preset: $( '#awf-preset-id' ).val(),
          awf_filter: $popup.attr( 'data-filter-id' ),
          awf_clone_filter: $( '#awf-apply-filter-clone-select' ).val(),
          awf_ajax_referer: awf_js_data.awf_ajax_referer
        },
        success:  function() {
          if( false !== a_w_f.url_params ) {
            a_w_f.url_params.set( 'awf-goto', 'awf-filter-' + $( '#awf-preset-id' ).val() + '-' + $popup.attr( 'data-filter-id' ) );
            a_w_f.url_params.set( 'awf-force-submit', 1 );
            a_w_f.set_new_url();
          }

          window.onbeforeunload = null;
          window.location.reload();
        },
        error: function( response ) {
          a_w_f.ajax_error_response( response );
        }
      });
    }
  };

  a_w_f.popup_create_filter_template = function() {
    var $overlay = $('.awf-spinner-overlay');
    $overlay.show();

    $.ajax({
      type:     "post",
      url:      "admin-ajax.php",
      dataType: "html",
      data:     {
        action: 'awf_admin',
        awf_action: 'popup-create-filter-template',
        awf_ajax_referer: awf_js_data.awf_ajax_referer
      },
      success:  function( response ) {
        $overlay.html( response );
      },
      error: function( response ) {
        a_w_f.ajax_error_response( response );
      }
    });
  };

  a_w_f.popup_create_filter_template_change_preset = function( $select ) {
    $('.awf-overlay-popup').block({ message: '' });

    $.ajax({
      type:     "post",
      url:      "admin-ajax.php",
      dataType: "html",
      data:     {
        action: 'awf_admin',
        awf_action: 'popup-create-filter-template-change-preset',
        awf_preset_id: $select.val(),
        awf_ajax_referer: awf_js_data.awf_ajax_referer
      },
      success:  function( response ) {
        $('.awf-spinner-overlay').html( response );
      },
      error: function( response ) {
        a_w_f.ajax_error_response( response );
      }
    });
  };

  a_w_f.create_filter_template = function( $btn ) {
    $('.awf-overlay-popup').block({ message: '' });

    $.ajax({
      type:     "post",
      url:      "admin-ajax.php",
      dataType: "json",
      data:     {
        action: 'awf_admin',
        awf_action: 'create-filter-template',
        awf_preset: $( '#awf-create-filter-template-presets-select' ).val(),
        awf_filter: $( '#awf-create-filter-template-filters-select' ).val(),
        awf_new_filter_template_name: $( '.awf-new-filter-template-name' ).first().val(),
        awf_ajax_referer: awf_js_data.awf_ajax_referer
      },
      success:  function( response ) {
        if( typeof response === 'object' && response.hasOwnProperty( 'filter_name' ) ) {
          if( false !== a_w_f.url_params ) {
            a_w_f.url_params.set( 'awf-filter', response.filter_name );
            a_w_f.set_new_url();
         }
          window.onbeforeunload = null;
          window.location.reload();
        }
      },
      error: function( response ) {
        a_w_f.ajax_error_response( response );
      }
    });
  };

  a_w_f.popup_rename_filter_template = function( $btn ) {
    var $overlay = $('.awf-spinner-overlay');
    $overlay.show();

    $.ajax({
      type:     "post",
      url:      "admin-ajax.php",
      dataType: "html",
      data:     {
        action: 'awf_admin',
        awf_action: 'popup-rename-filter-template',
        awf_filter_template_id: $btn.closest( '.awf-template-row' ).attr( 'data-filter-template-id' ),
        awf_ajax_referer: awf_js_data.awf_ajax_referer
      },
      success:  function( response ) {
        $overlay.html( response );
      },
      error: function( response ) {
        a_w_f.ajax_error_response( response );
      }
    });
  };

  a_w_f.rename_filter_template = function( $btn ) {
    $('.awf-spinner-overlay').show();

    $.ajax({
      type:     "post",
      url:      "admin-ajax.php",
      dataType: "html",
      data:     {
        action: 'awf_admin',
        awf_action: 'rename-filter-template',
        awf_filter_template_id: $btn.attr( 'data-filter-template-id' ),
        awf_filter_template_name: $( '.awf-rename-filter-template' ).first().val(),
        awf_ajax_referer: awf_js_data.awf_ajax_referer
      },
      success:  function( response ) {
        window.onbeforeunload = null;
        window.location.reload();
      },
      error: function( response ) {
        a_w_f.ajax_error_response( response );
      }
    });
  };

  a_w_f.export_filter_template = function( $btn ) {
    var $overlay = $('.awf-spinner-overlay');
    $overlay.show();

    $.ajax({
      type:     "post",
      url:      "admin-ajax.php",
      dataType: "html",
      data:     {
        action: 'awf_admin',
        awf_action: 'export-filter-template',
        awf_filter_template_id: $btn.closest( '.awf-template-row' ).attr( 'data-filter-template-id' ),
        awf_ajax_referer: awf_js_data.awf_ajax_referer
      },
      success:  function( response ) {
        var $response = a_w_f.ajax_html_response_to_jquery( response, 'export-filter-template' );
        var $notice = $response.insertAfter( $( '#awf-settings > h2' ).first() );
        var $link = $notice.find( '.awf-filter-template-download-link' );
				if( 0 < $link.length ) { $link[0].click(); }
        $overlay.hide();
      },
      error: function( response ) {
        a_w_f.ajax_error_response( response );
      }
    });
  };

  a_w_f.delete_filter_template = function( $btn ) {
    $('.awf-spinner-overlay').show();

    $.ajax({
      type:     "post",
      url:      "admin-ajax.php",
      dataType: "html",
      data:     {
        action: 'awf_admin',
        awf_action: 'delete-filter-template',
        awf_filter_template_id: $btn.attr( 'data-filter-template-id' ),
        awf_ajax_referer: awf_js_data.awf_ajax_referer
      },
      success:  function( response ) {
        window.onbeforeunload = null;
        window.location.reload();
      },
      error: function( response ) {
        a_w_f.ajax_error_response( response );
      }
    });
  };

  a_w_f.clone_preset = function( preset_id ) {
    $('.awf-spinner-overlay').show();

    $.ajax({
      type:     "post",
      url:      "admin-ajax.php",
      dataType: "html",
      data:     {
        action: 'awf_admin',
        awf_action: 'clone-preset',
        awf_preset_id: preset_id,
        awf_ajax_referer: awf_js_data.awf_ajax_referer
      },
      success: function( response ) {
        if( 0 < response.length ) {
          window.onbeforeunload = null;
          window.history.pushState( '', '', response );
          window.location.href =  response;

        } else {
          a_w_f.display_admin_notice( awf_js_data.l10n.preset_cloning_error );
          $('.awf-spinner-overlay').hide();
        }
        
      },
      error: function( response ) {
        a_w_f.ajax_error_response( response );
      }
    });
  };
  
  function awf_update_presets_positions( $sortable ) {
    $('.awf-spinner-overlay').show();
    var positions = [];
		$( '#awf-settings table.awf-presets-table > tbody > tr' ).each( function() {
      positions.push( $( this ).attr('data-id') );
		});
        
    $.ajax({
      type:     "post",
      url:      "admin-ajax.php",
      data:     {
        action: 'awf_admin',
        awf_action: 'update_presets_positions',
        awf_presets_positions: positions,
        awf_ajax_referer: awf_js_data.awf_ajax_referer },
      success:  function( response ) {
        $( '.awf-spinner-overlay' ).hide();
      },
      error: function( response ) {
        $sortable.sortable( 'cancel' );
        a_w_f.ajax_error_response( response );
      }
    });
  }
  
  function awf_update_seo_filters_positions( $sortable, $row ) {
    $('.awf-spinner-overlay').show();
    
    var positions = [];
		$( '#awf-settings table.awf-seo-modules-list-table > tbody > tr.awf-seo-filter-settings-container' ).each( function() {
      positions.push( $( this ).attr('id') );
		});
        
    $.ajax({
      type:     "post",
      url:      "admin-ajax.php",
      data:     {
        action: 'awf_admin',
        awf_action: 'update_seo_filters_positions',
        awf_seo_filters_positions: positions,
        awf_ajax_referer: awf_js_data.awf_ajax_referer
      },
      success:  function( response ) {
        $( '.awf-spinner-overlay' ).hide();
      },
      error: function( response ) {
        $sortable.sortable( 'cancel' );
        a_w_f.ajax_error_response( response );
      }
    });
  }
  
  function awf_set_image_preview( $url_input ) {
    var $container = $url_input.closest( '.awf-image-term-container' );
    var url = $url_input.val().toString().trim();
		
		$url_input.val( url );
		
    if( 0 === url.length ) { url = 'data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///yH5BAEAAAAALAAAAAABAAEAAAIBRAA7'; }
    $container.find( '.awf-image-preview' ).attr( 'src', url ); 
    $container.find( '.awf-image-id' ).val( '' );
  }
  
  function awf_set_one_image_preview( $url_input ) {
    var $container = $url_input.closest( '.awf-one-image-container' );
    var url = $url_input.val().toString().trim();
		
		$url_input.val( url );
		
    if( 0 === url.length ) { url = 'data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///yH5BAEAAAAALAAAAAABAAEAAAIBRAA7'; }
    $container.find( '.awf-image-preview' ).attr( 'src', url ); 
    $container.find( '.awf-image-id' ).val( '' ); 
  }
  
  function awf_set_taxonomy_range_sortables( $container ) {
    $container.closest( '.awf-filter-options' ).find( 'table.awf-taxonomy-range-container > tbody' ).sortable({
      items: '> tr.awf-range-term-container',
      containment: 'parent',
      handle: '.sort-handle',
      placeholder: 'awf-sortable-placeholder',
      tolerance: 'pointer',
      axis: 'y',
      update: function() {
        awf_update_taxonomy_range_positions( $( this ) );
      }
    });
  }
  
  function awf_update_taxonomy_range_positions( $sortable ) {
    var $container = $sortable.closest( 'tbody' );
    var positions = [];
    var labels = [];
    var pieces = '';
    
    $container.block({ message: '' });
    
		$container.find( '> tr.awf-range-term-container' ).each( function() {
      var id = $( this ).attr('id').replace( '_container', '' );
      pieces = id.split( '_' );
      
      positions.push( pieces.pop() );
      labels.push( $( this ).find( 'input[name="' + id + '_label"]' ).val() );
		});
    
    $.ajax({
      type:     "post",
      url:      "admin-ajax.php",
      data:     {
        action: 'awf_admin',
        awf_action: 'update-range-positions',
        awf_preset: $( '#awf-preset-id' ).val(),
        awf_filter: a_w_f.get_filter_id( $container ),
        awf_range_positions: positions,
        awf_range_labels: labels,
        awf_ajax_referer: awf_js_data.awf_ajax_referer
      },
      success:  function( response ) {
        var priority = 1;
        $sortable.closest( 'tbody' ).find( 'td.sort-handle' ).each( function() {
          $( this ).find( 'span' ).html( priority );
          $( this ).find( 'input' ).val( priority );
          priority++;
        });
        
        $container.unblock();
        a_w_f.rebuild_filter_style_options( $container.closest( '.awf-filter-options' ).find( '.awf-filter-style-select' ) );
      },
      error: function( response ) {
        $sortable.sortable( 'cancel' );
        a_w_f.ajax_error_response( response );
      }
    });
  }

  if( ( 'settings_wrapper' in a_w_f ) && 0 < a_w_f.settings_wrapper.length ) {
    var $document = $( document );

    if( a_w_f.settings_wrapper.hasClass( 'awf-preset-settings' ) ) {

      var $presets_table = a_w_f.settings_wrapper.find( 'table.awf-presets-table' );

      if( 0 < $presets_table.length ) {
        $presets_table.children( 'tbody' ).sortable({
          items: '> tr',
          containment: 'parent',
          handle: '.sort-handle',
          placeholder: 'awf-sortable-placeholder',
          tolerance: 'pointer',
          axis: 'y',
          update: function() {
            awf_update_presets_positions( $( this ) );
          }
        });

        $presets_table.find( '.awf-fa-delete-btn' ).click( function( e ) {
          if( ! a_w_f.confirm_deletion() ) { e.preventDefault(); }
        });

        $presets_table.find( '.awf-fa-clone-btn' ).click( function( e ) {
          a_w_f.clone_preset( $( this ).attr( 'data-preset-id' ) );
        });

      } else {
        var $preset_layout_select = $( '.awf-preset-layout' );
        var $custom_layout_btn = $( '#awf-popup-custom-layout-btn' );

        if( 0 < $preset_layout_select.length ) {
          $preset_layout_select.on( 'change', function() {
            if( 'custom' === $( this ).val() ) {
              $custom_layout_btn.show();
            } else {
              $custom_layout_btn.hide();
            }
          });

          $custom_layout_btn
            .on( 'click', function() {
              a_w_f.popup_custom_layout();
            })
            .insertAfter( '.awf-preset-layout' );

          if( 'custom' === $preset_layout_select.val() ) { $custom_layout_btn.show(); }
        }

        $( '.awf-popup-preset-templates-btn' ).on( 'click', function( event ) {
          a_w_f.popup_preset_templates( $( this ) );
        } );

        var $spinner_overlay = $( '.awf-spinner-overlay' );

        $spinner_overlay
        .on( 'click', function( event ) {
          event.stopPropagation();
        } )
        .on( 'click', '.awf-apply-preset-template-btn', function( event ) {
          a_w_f.apply_preset_template();
        } )
        .on( 'click', '.awf-apply-preset-clone-btn', function( event ) {
          a_w_f.apply_preset_clone();
        } )
        .on( 'click', '.awf-apply-filter-template-btn', function( event ) {
          a_w_f.apply_filter_template();
        } )
        .on( 'click', '.awf-apply-filter-clone-btn', function( event ) {
          a_w_f.apply_filter_clone();
        } )
        .on( 'click', '#awf-add-custom-layout-column-btn', function() {
          a_w_f.update_custom_layout( 'add' );
        } )
        .on( 'click', '.awf-delete-custom-layout-column-btn', function() {
          a_w_f.update_custom_layout( 'delete', $( this ).attr( 'data-column-n') );
        } )
        .on( 'click', '#awf-save-custom-layout-btn', function() {
          a_w_f.update_custom_layout();
        } )
        ;

        $document.on( 'change', 'input.awf-one-image-on', function() {
          $( this ).closest( '.awf-style-options-container' ).find( '.awf-terms-images-container' ).toggle();
          $( this ).closest( '.awf-style-options-container' ).find( '.awf-one-image-container' ).toggle();
        } );
        $document.on( 'change', '.awf-one-image-url', function() { awf_set_one_image_preview( $( this ) ); } );
        $document.on( 'change', '.awf-image-url', function() { awf_set_image_preview( $( this ) ); } );
        $document.on( 'click', '.awf-media-handler-btn', function( e ) { awf_call_wp_media_handler( e, this ); } );

        $document.on( 'change', '.awf-custom-terms-container .awf-solid-icon', function() { a_w_f.change_icon_weight( $( this ) ); } );
        $document.on( 'change', '.awf-custom-terms-container .awf-solid-icon-hover', function() { a_w_f.change_icon_weight( $( this ), '.awf-filter-icon-hover' ); } );
        $document.on( 'change', '.awf-custom-terms-container .awf-solid-icon-active', function() { a_w_f.change_icon_weight( $( this ), '.awf-filter-icon-active' ); } );
        $document.on( 'change', '.awf-custom-terms-container .awf-solid-icon-active-hover', function() { a_w_f.change_icon_weight( $( this ), '.awf-filter-icon-active-hover' ); } );
        $document.on( 'change', '.awf-custom-layout-autowidth-container > input', function() { $( this ).closest( '.awf-custom-layout-column-container' ).toggleClass( 'awf-autowidth-on' ); } );
        $document.on( 'change', '.awf-range-slider-hide-slider-labels', function() { $( this ).closest( '.awf-style-options-container' ).find( '.awf-range-slider-preview' ).toggleClass( 'awf-rsp-hide-labels' ); } );
        $document.on( 'change', '.awf-range-slider-hide-slider-poles', function() { $( this ).closest( '.awf-style-options-container' ).find( '.awf-range-slider-preview' ).toggleClass( 'awf-rsp-hide-poles' ); } );
        $document.on( 'change', '.awf-range-slider-hide-slider', function() { $( this ).closest( '.awf-style-options-container' ).find( '.awf-range-slider-preview' ).toggleClass( 'awf-rsp-hide-slider' ).siblings( '.awf-interactive-slider-tooltips-container' ).toggleClass( 'awf-slider-hidden' ); } );
        $document.on( 'click', '.awf-popup-filter-templates-btn', function( e ) {
          a_w_f.popup_filter_templates( $( this ) );
        } );
      }

    } else if( a_w_f.settings_wrapper.hasClass( 'awf-tab-product-list-settings' ) ) {

      $( 'table.awf-template-options-table .awf_template_option_active_badges_hook' ).each( function() {
        a_w_f.toggle_active_badges_hook( $( this ) );
      })

      $document.on( 'change', 'table.awf-template-options-table .awf_template_option_active_badges_hook', function() {
        a_w_f.toggle_active_badges_hook( $( this ) );
      });

      $document.on( 'awf_product_list_template_options_reload', function() {
        $( 'table.awf-template-options-table .awf_template_option_active_badges_hook' ).each( function() {
          a_w_f.toggle_active_badges_hook( $( this ) );
        })
      });

    } else if( a_w_f.settings_wrapper.hasClass( 'awf-tab-templates-settings' ) ) {
      $( 'a' ).on( 'click', function() {
        window.onbeforeunload = null;
      });

      var $spinner_overlay = $( '.awf-spinner-overlay' );

      a_w_f.settings_wrapper
      .on( 'change', '#awf-templates-filters-select', function() {
        $spinner_overlay.show();
        if( false !== a_w_f.url_params ) {
          a_w_f.url_params.set( 'awf-filter', $( this).val() );
        }
        a_w_f.set_new_url();
        window.onbeforeunload = null;
        window.location.reload();
      } )
      .on( 'click', '.awf-popup-create-preset-template-btn', function() {
        a_w_f.popup_create_preset_template();
      } )
      .on( 'click', '.awf-create-preset-template-btn', function() {
        a_w_f.create_preset_template( $( this ) );
      } )
      .on( 'click', '.awf-popup-rename-preset-template-btn', function() {
        a_w_f.popup_rename_preset_template( $( this ) );
      } )
      .on( 'click', '.awf-rename-preset-template-btn', function() {
        a_w_f.rename_preset_template( $( this ) );
      } )
      .on( 'click', '.awf-export-preset-template-btn', function() {
        a_w_f.export_preset_template( $( this ) );
      } )
      .on( 'click', '.awf-import-preset-template-btn', function() {
        $( '#awf-import-json-preset-template' )[0].click();
      } )
      .on( 'change', '#awf-import-json-preset-template', function( event ) {
        a_w_f.import_template( event, 'preset' );
      } )

      .on( 'click', '.awf-delete-preset-template-btn', function() {
        if( a_w_f.confirm_deletion() ) { a_w_f.delete_preset_template( $( this ) ); }
      } )
      .on( 'click', '.awf-popup-create-filter-template-btn', function() {
        a_w_f.popup_create_filter_template();
      } )
      .on( 'change', '#awf-create-filter-template-presets-select', function() {
        a_w_f.popup_create_filter_template_change_preset( $( this ) );
      } )
      .on( 'click', '.awf-create-filter-template-btn', function() {
        a_w_f.create_filter_template( $( this ) );
      } )
      .on( 'click', '.awf-popup-rename-filter-template-btn', function() {
        a_w_f.popup_rename_filter_template( $( this ) );
      } )
      .on( 'click', '.awf-rename-filter-template-btn', function() {
        a_w_f.rename_filter_template( $( this ) );
      } )
      .on( 'click', '.awf-export-filter-template-btn', function() {
        a_w_f.export_filter_template( $( this ) );
      } )
      .on( 'click', '.awf-import-filter-template-btn', function() {
        $( '#awf-import-json-filter-template' )[0].click();
      } )
      .on( 'change', '#awf-import-json-filter-template', function( event ) {
        a_w_f.import_template( event, 'filter' );
      } )
      .on( 'click', '.awf-delete-filter-template-btn', function() {
        if( a_w_f.confirm_deletion() ) { a_w_f.delete_filter_template( $( this ) ); }
      } )
      ;

    } else if( a_w_f.settings_wrapper.hasClass( 'awf-tab-seo-settings' ) ) {
      a_w_f.settings_wrapper.find( 'table.awf-seo-modules-list-table > tbody' ).sortable({
        items: '> tr.awf-seo-filter-settings-container',
        containment: 'parent',
        handle: '.sort-handle',
        placeholder: 'awf-sortable-placeholder',
        tolerance: 'pointer',
        axis: 'y',
        update: function( event, ui ) {
          awf_update_seo_filters_positions( $( this ), ui.item );
        }
      });

    } else if( a_w_f.settings_wrapper.hasClass( 'awf-tab-plugin-settings' ) ) {
              
      if( false !== a_w_f.url_params ) {
        if( a_w_f.url_params.has( 'awf-advanced-plugin-settings-expanded' ) ) {
          $( '.awf-advanced-plugin-settings-toggle' ).removeClass( 'awf-advanced-plugin-collapsed' ).closest( 'table' ).next( 'table' ).find( '.awf-hidden' ).removeClass( 'awf-hidden' );
        }
      }

      $( '.awf-advanced-plugin-settings-toggle h2' ).on( 'click', function() {
        $( this ).closest( '.awf-advanced-plugin-settings-toggle' ).toggleClass( 'awf-advanced-plugin-collapsed' ).closest( 'table' ).next( 'table' ).find( '.awf-pretty-query-var-names-container, .awf-tax-query-operators-container' ).toggleClass( 'awf-hidden' );
        
        if( false !== a_w_f.url_params ) {
          if( a_w_f.url_params.has( 'awf-advanced-plugin-settings-expanded' ) ) {
            a_w_f.url_params.delete( 'awf-advanced-plugin-settings-expanded' );
          } else {
            a_w_f.url_params.set( 'awf-advanced-plugin-settings-expanded', 1 );
          }
    
          a_w_f.set_new_url();
        }
      });
    }

    $document.trigger( 'awf_after_premium_admin_setup' );

  }
    
});