function awf_call_wp_media_handler( e, el ) {
  'use strict';
  
  e.preventDefault();

  var select_btn = jQuery( el );
  var image_id;
  var image_url;
  var image_preview;

  if( select_btn.hasClass(  'awf-one-image-handler' ) ) {
    image_id = jQuery( el ).siblings( 'input.awf-image-id' );
    image_preview = jQuery( el ).siblings( 'img.awf-image-preview' );
    image_url = jQuery( el ).closest( '.awf-one-image-container' ).find( 'input.awf-one-image-url' );
    
  } else {
    var $container = jQuery( el ).closest( '.awf-image-term-container' );
    image_id = $container.find( 'input.awf-image-id' );
    image_preview = $container.find( 'img.awf-image-preview' );
    image_url = $container.find( 'input.awf-image-url' );
  }

  var image_frame;
  if( image_frame ){
    image_frame.open();
    return;
  }

  image_frame = wp.media({
    title: 'Select Image',
    multiple : false,
    library : {
      type : 'image',
    }
  });

  image_frame.on( 'select', function() {
    var attachment = image_frame.state().get( 'selection' ).first().toJSON();
    jQuery( image_id ).val( attachment.id );
    jQuery( image_url ).val( attachment.url );
    jQuery( image_preview ).attr( 'src', attachment.url );       
  });

  image_frame.on( 'open', function() {
    var selection =  image_frame.state().get( 'selection' );
    var id = jQuery( image_id ).val();
    var attachment = wp.media.attachment( id );
    attachment.fetch();
    selection.add( attachment ? [ attachment ] : [] );
  });

  image_frame.open();
}