<?php

defined( 'ABSPATH' ) or die( 'Access denied' );

if( ! class_exists('A_W_F_premium_frontend') ) {

  class A_W_F_premium_frontend extends A_W_F_frontend {
    
    public $reset_all_url_exceptions;
    
    protected function __construct() {
      parent::__construct();
      
      $this->filters_manager = 'A_W_F_premium_filter_frontend';
      add_action( 'wp_enqueue_scripts', array( $this, 'enqueue_premium_scripts'), 5 );
    }
    
    public function enqueue_premium_scripts( $hook ) {
      wp_enqueue_script( 'awf-premium', A_W_F_PLUGIN_URL . '/code/js/awf-premium.js', array( 'jquery', 'jquery-ui-core', 'jquery-ui-sortable', 'jquery-blockui', 'awf-nouislider' ), A_W_F::$plugin_version );
    }
        
    public function register_shortcodes() {
      parent::register_shortcodes();

      add_shortcode( 'annasta_filters_active_badges', array( $this, 'active_badges_shortcode' ) );
    }
    
    public function active_badges_shortcode( $atts ) {
      return '<div class="awf-active-badges-container awf-extra-badges"></div>';
    }
    
    protected function set_numeric_taxonomy_ranges() {
      
      if( empty( $this->query->range ) ) { return; }

      foreach( $this->vars->tax as $taxonomy => $taxonomy_name ) {
        
        if( $taxonomy === $this->is_archive ) {
          unset( $this->query->range['min_' . $taxonomy] );
          unset( $this->query->range['max_' . $taxonomy] );
          
          continue;
        }
        
        if( isset( $this->query->range['min_' . $taxonomy] ) && isset( $this->query->range['max_' . $taxonomy] ) ) {
          $min = $this->query->range['min_' . $taxonomy];
          $max = $this->query->range['max_' . $taxonomy];

          if( $min > $max ) {
            $temp = $min;
            $min = $max;
            $max = $temp;
          }
          
          $encoded_slugs = get_terms( array( 
            'taxonomy' => $taxonomy,
            'fields' => 'slugs',
            'hide_empty' => false,
            'menu_order' => false,
            'orderby' => 'none',
          ) );

          if( ! is_wp_error( $encoded_slugs ) ) {
            $slugs = array();

            foreach( $encoded_slugs as $slug ) {
              $slug = urldecode( $slug );
              $float = preg_replace( '/(?<=[0-9])-(?=[0-9])/', '.', $slug );
              $float = (float) preg_replace( "/[^0-9,.]/", "", $float );

              if( $float >= $min && $float <= $max ) {
                $slugs[$slug] = $float;
              }
            }

            if( empty( $slugs) ) { $slugs = array( 'no-awf-range-term-found' => 0 ); }
            $this->query->tax[$taxonomy] = array_keys( $slugs );
          }
        }
      }
    }
    
    public function build_reset_all_url_exceptions() {
      $exceptions = get_option( 'awf_reset_all_exceptions', array( 'ppp', 'orderby' ) );

      foreach( $exceptions as $exception ) {
        if( isset( A_W_F::$front->query->awf[$exception] ) ) {
          A_W_F::$front->reset_all_url_exceptions[A_W_F::$front->vars->awf[$exception]] = A_W_F::$front->query->awf[$exception];

        } elseif( isset( A_W_F::$front->query->tax[$exception] ) ) {
          A_W_F::$front->reset_all_url_exceptions[A_W_F::$front->vars->tax[$exception]] = implode( ',', A_W_F::$front->query->tax[$exception] );

        } elseif( isset( A_W_F::$front->query->range['min_' . $exception] ) ) {
          A_W_F::$front->reset_all_url_exceptions[A_W_F::$front->vars->range['min_' . $exception]] = A_W_F::$front->query->range['min_' . $exception];

        } elseif( isset( A_W_F::$front->query->range['max_' . $exception] ) ) {
          A_W_F::$front->reset_all_url_exceptions[A_W_F::$front->vars->range['max_' . $exception]] = A_W_F::$front->query->range['max_' . $exception];
        }
      }
    }
    
    protected function hook_active_badges( $data ) {
      if( 'js' !== $data['hook'] ) {
        add_action( $data['hook'], array( $this, 'display_active_badges' ), $data['priority'] );
      }
    }
    
    public function display_active_badges() {
      echo '<div class="awf-active-badges-container awf-extra-badges"></div>';
    }
    
    public function display_reset_btn() {
      echo '<div class="awf-reset-btn-container awf-extra-reset-btn-container" style="display:none;"><button type="button" title="' . esc_attr__( 'Clear all filters', 'annasta-filters' ) . '" class="awf-reset-btn awf-extra-reset-btn">' . esc_html( __( 'Clear all filters', 'annasta-filters' ) ) . '</button></div>';
    }
    
    public function get_reset_all_exceptions( $exceptions = array() ) {
      $exceptions = array_merge( $exceptions, get_option( 'awf_reset_all_exceptions', array( 'ppp', 'orderby' ) ) );

      if( $this->is_archive ) {
        array_push( $exceptions, $this->is_archive, $this->vars->misc['archive'] );
      }
      
      foreach( $exceptions as $i => $exception ) {
        if( isset( $this->vars->awf[$exception] ) ) {
          $exceptions[$i] = $this->vars->awf[$exception];
        } elseif( isset( $this->vars->tax[$exception] ) ) {
          $exceptions[$i] = $this->vars->tax[$exception];
        } elseif( isset( $this->vars->range['min_' . $exception] ) ) {
          $exceptions[$i] = $this->vars->range['min_' . $exception];
          $exceptions[] = $this->vars->range['max_' . $exception];
        }
      }
      
      return $exceptions;
    }

  }
}

?>